/*
 * $Id: ChatMessage.java 223 2007-10-14 08:07:40Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/03/11
 */
package feat2.testapp.flash;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * チャットメッセージ
 * @author SUGIMOTO
 */
public class ChatMessage {

    private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    private int index;
    private String username;
    private String message;
    private Date date;

    public ChatMessage(String un, String mes) {
        username = un;
        if ( username == null )
            username = "名無しさん";
        message = mes;
        date = new Date();
    }



    public int getIndex() {
        return index;
    }
    public void setIndex(int index) {
        this.index = index;
    }
    public Date getDate() {
        return date;
    }
    public String getMessage() {
        return message;
    }
    public String getUsername() {
        return username;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(format.format(date));
        buf.append(" username:").append(username);
        buf.append(" message:").append(message);
        return buf.toString();
    }
}
