/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * (C) 2004 SUGIMOTO Ken-ichi
 */

package feat2;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

public class FeatErrors {

    private List errors;
    private ResourceManager resourceManager;

    public FeatErrors(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        errors = new ArrayList();
    }

    public ResourceManager getResourceManager() {
        return resourceManager;
    }

    public int count() {
        return errors.size();
    }

    public void add(FeatError error) {
        error.setResourceManager(resourceManager);
        errors.add(error);
    }

    /**
     * FeatErrorのリストを反復するイテレータを返す。
     * @return Iterator
     */
    public Iterator iterator() {
        return errors.iterator();
    }

    /**
     * 指定された型のインスタンス(type.isInstance()でtrueになるオブジェクト)をすべて返す。
     * @param type
     * @return
     */
    public FeatError[] getErrors(Class type) {

        ArrayList hits = new ArrayList();

        for (Iterator iter = errors.iterator(); iter.hasNext();) {

            Object err = iter.next();
            if ( type.isInstance(err) ) {
                hits.add(err);
            }

        }

        return (FeatError[])hits.toArray(new FeatError[0]);

    }

    /**
     * 指定されたエラーレベルのエラーを返す。
     * @param errorLevel
     * @return
     */
    public FeatError[] getErrors(int errorLevel) {

        ArrayList hits = new ArrayList();

        for (Iterator iter = errors.iterator(); iter.hasNext();) {

            FeatError err = (FeatError)iter.next();
            if ( err.getErrorLevel() == errorLevel ) {
                hits.add(err);
            }

        }

        return (FeatError[])hits.toArray(new FeatError[0]);

    }

}
