/*
 * $Id: FeatRuntimeException.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005-2006 SUGIMOTO Ken-ichi
 * 作成日: 2005/07/30
 */
package feat2;

import java.util.HashMap;

/**
 * 本来起こるはずのない状況のときに投げられる例外。
 * @author SUGIMOTO Ken-ichi
 */
public class FeatRuntimeException extends RuntimeException {

    private static final long serialVersionUID = "$Id: FeatRuntimeException.java 220 2007-07-16 10:32:15Z sugimotokenichi $".hashCode();

    private String messageId;
    private HashMap keywords;


    public FeatRuntimeException() {
        super();
        keywords = new HashMap();
    }

    public FeatRuntimeException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatRuntimeException(String messageId) {
        super();
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatRuntimeException(Throwable cause) {
        super(cause);
        keywords = new HashMap();
    }


    public String getMessageId() {
        return messageId;
    }


    /**
     * メッセージ中のキーワード置き換えを追加する。
     * @param key
     * @param word
     */
    public void addKeyword(String key, String word) {
        keywords.put(key, word);
    }


    /**
     * メッセージIDに対応するエラーメッセージを返す。
     * リソースマネージャはデフォルトのFileResourceManagerが使われる。
     * リソースが見つからないときはリソースIDを返す。
     */
    public String getMessage() {

        String message = null;
        if ( messageId != null )
            message = FileResourceManager.getInstance().getStringResource(messageId);

        if ( message == null )
            return messageId;

        message = StringUtil.replaceParameters(message, keywords);
        return message;

    }

}
