/*
 * $Id: FeatureConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import java.util.Locale;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;


/**
 * feat設定ファイルのフィーチャーの設定。
 * @author SUGIMOTO Ken-ichi
 */
public class FeatureConfig extends Config {

    private String templatePath;
    private String configFilename;
    private FileLocator configFileLocator;
    private FeatureRootConfig featureRoot;

    public FeatureConfig() {
    }

    // プロパティ -------------------------------------------------------------

    public String getConfigFilename() {
        return configFilename;
    }
    public void setConfigFilename(String configFile) {
        this.configFilename = configFile;
    }

    public String getTemplatePath() {
        return templatePath;
    }
    public void setTemplatePath(String templateDir) {
        this.templatePath = templateDir;
    }

    public void setFeatureRoot(FeatureRootConfig conf) {
        featureRoot = conf;
        featureRoot.setParent(this);
    }

    public FileLocator getConfigFileLocator() {
        return configFileLocator;
    }

    /**
     * このプロパティはConfigReaderからセットされる。
     * @param configFileLocator
     */
    public void setConfigFileLocator(FileLocator configFileLocator) {
        this.configFileLocator = configFileLocator;
    }

    // FeatureRootConfigの委譲メソッド ----------------------------------------

    public String getEncoding() {
        return featureRoot.getEncoding();
    }

    public Identifier getName() {
        return featureRoot.getName();
    }

    public JavaIdentifier getPackageName() {
        return featureRoot.getPackageName();
    }

    public Boolean getCreateSession() {
        return featureRoot.getCreateSession();
    }

    public CommandConfig getCommandConfig(String commandName) {
        return featureRoot.getCommandConfig(commandName);
    }

    public ResponseConfigBase getResponseConfig(String name) {
        return featureRoot.getResponseConfig(name);
    }

    public String getStringResource(String resourceName, Locale locale) {
        return featureRoot.getStringResource(resourceName, locale);
    }

    public Resources getResources() {
        return featureRoot.getResources();
    }

    public InterceptConfig[] getInterceptConfigs() {
        return featureRoot.getInterceptConfigs();
    }

    public ExceptionConfig getException(Class exclass) {
        return featureRoot.getException(exclass);
    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "feature";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        // templatePath

        if ( templatePath == null )
            errs.add(new ConfigError(templatePath, "template-path", ConfigError.TYPE_NULL, FeatError.ERROR, this));

        // featureRoot

        ret = ret && featureRoot.validate(errs);

        // configFilenameはこのメソッドより前に使われるので検証しない

        return ret;

    }


}
