/*
 * $Id: FetchConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.Action;
import feat2.FeatError;
import feat2.FeatErrors;
import feat2.Fetcher;

/**
 * フェッチコンポーネントの設定
 * @author SUGIMOTO Ken-ichi
 */
public class FetchConfig extends ActionConfigBase {

    private long cache;

    public FetchConfig() {
        cache = 0L;
    }


    // プロパティ -------------------------------------------------------------

    public long getCache() {
        return cache;
    }
    public void setCache(long cache) {
        this.cache = cache;
    }



    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "fetch";
    }

    public Action getActionInstance() {

        try {

            return (Action) getActionClass().newInstance();

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( !Fetcher.class.isAssignableFrom(getActionClass()) ) {
            ret = false;
            errs.add( new ConfigError(getClassName().getValue(), "class", ConfigError.TYPE_FETCHER_INTERFACE, FeatError.ERROR, this) );
        }

        if ( cache < 0L ) {
            errs.add(new ConfigError(Long.toString(cache), "error.config.fetch.cache", FeatError.ERROR, this));
            ret = false;
        }

        return ret;
    }

}
