/*
 * $Id: FileConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/05/15
 */
package feat2.config;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.FileDownload;
import feat2.Response;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;
import feat2.impl.FileDownloadResponse;

/**
 * ファイルダウンロードの設定。
 * @author SUGIMOTO Ken-ichi
 */
public class FileConfig extends ResponseConfigBase implements DIComponentConfig, ValidatableComponentConfig{

    private JavaIdentifier className;
    private String filename;
    private String contentType;
    private Identifier errorResponse;

    private InputSupport inputs;
    private ValidationSupport validations;

    // validateで有効になる変数

    private Class fileDownloadClass;


    public FileConfig() {

        inputs = new InputSupport(this);
        validations = new ValidationSupport(this);

    }

    // プロパティ -------------------------------------------------------------

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }


    public String getFilename() {
        return filename;
    }
    public void setFilename(String filename) {
        this.filename = filename;
    }


    public String getContentType() {
        return contentType;
    }
    public void setContentType(String mimeType) {
        this.contentType = mimeType;
    }


    public Identifier getErrorResponse() {
        return errorResponse;
    }
    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }


    // DIComponentConfigのメソッド --------------------------------------------

    public void addInput(InputConfigBase input) {
        inputs.addInput(input);
        input.setParent(this);
    }
    public InputConfigBase[] getInputs() {
        return inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return inputs.getInputConfig(propertyName);
    }


    // ValidatableComponentConfigのメソッド -----------------------------------

    public void addValidation(ValidationConfig validation) {
        validations.addValidation(validation);
    }

    public ValidationConfig[] getValidations() {
        return validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return getInputConfig(propertyName).getDisplayName();
    }


    // ResponseConfigBaseのメソッド -------------------------------------------

    public Response getResponseInstance() {

        try {

            FileDownload download = (FileDownload)fileDownloadClass.newInstance();
            FileDownloadResponse response = new FileDownloadResponse(download, this);
            return response;

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "file";
    }


    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        fileDownloadClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( fileDownloadClass == null )
            ret = false;
        else if ( !FileDownload.class.isAssignableFrom(fileDownloadClass) ) {
            errs.add(new ConfigError(className.getValue(), "class", ConfigError.TYPE_FILEDOWNLOAD_INTERFACE, FeatError.ERROR, this) );
        }

        if ( validations.count() > 0 && errorResponse == null ) {
            errs.add( new ConfigError(null, "error-response", ConfigError.TYPE_ERROR_RESPONSE, FeatError.ERROR, this) );
        }

        ret = ret && inputs.validate(errs);
        ret = ret && validations.validate(errs);

        return ret;

    }



}
