/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

package feat2.config;

import java.io.IOException;
import java.io.InputStream;

import feat2.FeatException;

/**
 * ファイルの場所を表すためのインタフェース。
 */
public interface FileLocator {

    /**
     * ファイルを開いてInputStreamを返す。
     * @throws FeatException
     * @return InputStream
     */
    public InputStream openInputStream() throws IOException;

    /**
     * ファイルの場所のURIを文字列にして返す。
     * @return
     */
    public String getURIString();

    public boolean exists();

    /**
     * このオブジェクトが表す場所のファイル名を返す。
     * このオブジェクトがディレクトリを指している場合はnullを返す。
     * @return
     */
    public String getFilename();

    public long getLastModified() throws IOException;

    /**
     * 現在の場所から新しい場所を指し示すオブジェクトを作る。
     * 現在位置より上位の場所を指定することはできない。
     * @param relativePath 新しい場所を現在の場所からの相対位置で表した文字列
     * @throws FeatException
     * @return FileLocator
     */
    public FileLocator newLocation(String relativePath) throws IllegalArgumentException;

    /**
     * このオブジェクトがnewLocationで作られたオブジェクトのとき、一番元になったオブジェクトを返す。
     * 自分自身がルートの場合は自分自身を返す。
     * @return FileLocator
     */
    public FileLocator rootLocation();

}
