/*
 * $Id: ForwardConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.Response;
import feat2.impl.ForwardResponse;

/**
 * 委譲の設定。
 * @author SUGIMOTO Ken-ichi
 */
public class ForwardConfig extends ResponseConfigBase {

    private String path;

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Response getResponseInstance() {
        return new ForwardResponse(this);
    }

    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "forward";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        ret = ret && ConfigUtil.validateRequired(path, "path", this, errs);

        return ret;
    }
}
