/*
 * $Id: Resources.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import feat2.Util;

/**
 * リソース。
 * @author SUGIMOTO Ken-ichi
 */
public class Resources {

    private Map resourceMap;

    public Resources() {
        resourceMap = new HashMap();
    }

    public void addResource(String name, Locale lang, String value) {
        ResourceKey key = new ResourceKey(name, lang);
        resourceMap.put(key, value);
    }

    synchronized public void addResources(Resources resources) {
        resourceMap.putAll(resources.resourceMap);
    }

    /**
     * リソース文字列を返す。
     * langに厳密にマッチするリソースを返す。
     * @param name リソース名
     * @param lang 言語名(nullでも良い)
     */
    public String getString(String name, Locale lang) {
        String ret = (String)resourceMap.get(new ResourceKey(name, lang));
        return ret;
    }

    /**
     * 指定のリソースが少なくとも一つのロケールで定義されていればtrueを返す。
     * @param name
     * @return
     */
    public boolean exists(String name) {
        Set keys = resourceMap.keySet();
        for (Iterator iter = keys.iterator(); iter.hasNext();) {
            ResourceKey element = (ResourceKey) iter.next();
            if ( element.name.equals(name) )
                return true;
        }

        return false;
    }

    private class ResourceKey {
        String name;
        Locale lang;
        int hash;

        /**
         *
         * @param name
         * @param lang 言語。nullでも良い
         */
        ResourceKey(String name, Locale lang) {
            this.name = name;
            if ( lang == null )
                this.lang = Util.NULL_LOCALE;
            else
                this.lang = lang;
            this.hash = -1;
        }

        public boolean equals(Object o) {
            ResourceKey k = (ResourceKey)o;
            return name.equals(k.name) && lang.equals(k.lang);
        }

        public int hashCode() {
            if ( hash == -1 )
                hash = name.hashCode() ^ lang.hashCode();
            return hash;
        }
    }
}
