/*
 * $Id: Identifier.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/10
 */
package feat2.config.type;

import java.util.regex.Pattern;

import feat2.validation.ValidatorUtil;

/**
 * featの識別子。
 * @author SUGIMOTO Ken-ichi
 */
public class Identifier {

    private String value;

    public Identifier() {
        value = null;
    }

    public Identifier(String identifier) throws IllegalArgumentException {

        if ( !isIdentifier(identifier) ) {
            throw new IllegalArgumentException(); // TODO エラーメッセージ
        }

        this.value = identifier;
    }



    // Objectのメソッド

    public boolean equals(Object obj) {
        return value.equals( ((Identifier)obj).getValue() );
    }

    public int hashCode() {
        return value.hashCode();
    }

    public String toString() {
        return value;
    }



    // プロパティ -------------------------------------------------------------

    public String getValue() {
        return value;
    }

    // スタティックメソッド ---------------------------------------------------

    /**
     * 文字列がfeat識別子ならtrueを返す。
     * @param string
     * @return
     */
    public static boolean isIdentifier(String string) {

        // 文字を含まなかったらfalse

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        return identifierPattern.matcher(string).matches();

    }
    private static Pattern identifierPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");



}
