/*
 * $Id: JavaIdentifier.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/10
 */
package feat2.config.type;

import feat2.validation.ValidatorUtil;

/**
 * Javaの識別子('.'で区切られたパス形式を含む)。
 * @author SUGIMOTO Ken-ichi
 */
public class JavaIdentifier {

    private String value;

    public JavaIdentifier() {
        value = null;
    }

    public JavaIdentifier(String identifier) throws IllegalArgumentException {

        if ( !isJavaIdentifierPath(identifier) )
            throw new IllegalArgumentException(); // TODO エラーメッセージ

        this.value = identifier;
    }



    // Objectのメソッド

    public boolean equals(Object obj) {
        return value.equals( ((JavaIdentifier)obj).getValue() );
    }

    public int hashCode() {
        return value.hashCode();
    }

    public String toString() {
        return value;
    }



    // プロパティ -------------------------------------------------------------

    public String getValue() {
        return value;
    }


    // スタティックメソッド ---------------------------------------------------

    /**
     * 文字列がJava識別子のパス("aaa.bbb.ccc"など)ならtrueを返す。
     * @param string
     * @return
     */
    public static boolean isJavaIdentifierPath(String string) {

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        // '.'で分割

        String[] tokens = null;
        if ( string.indexOf('.') > -1 ) {
            tokens = string.split("\\.");
        }
        else {
            return isJavaIdentifier(string);
        }

        for (int i = 0; i < tokens.length; i++) {
            if ( !isJavaIdentifier(tokens[i]) )
                return false;
        }

        return true;
    }


    /**
     * 文字列がJava識別子ならtrueを返す。
     * @param string
     * @return
     */
    public static boolean isJavaIdentifier(String string) {

        // 文字を含まなかったらfalse

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        // 最初の文字

        if ( !Character.isJavaIdentifierStart(string.charAt(0)) )
            return false;

        // 2文字目以降

        for (int i = 1; i < string.length(); i++) {
            if ( !Character.isJavaIdentifierPart(string.charAt(i)) )
                return false;
        }

        return true;

    }

}
