/*
 * $Id: HTMLElement.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/07/24
 */
package feat2.template;


/**
 * HTMLの要素ノード。
 * 開始・終了タグのペア、開始タグのみ、終了タグのみの場合がある。
 * @author SUGIMOTO Ken-ichi
 */
public interface HTMLElement extends HTMLNode, CompositeNode {

    /**
     * この要素のid属性値を返す。
     * getAttribute("id")と同じ。
     * @return
     */
    public String getId();
    public void setId(String id);

    /**
     * この要素のclass属性値のリストを返す。
     * @return
     */
    public String[] getClassList();
    public void setClassValue(String classValue);
    /**
     * この要素のclass属性に指定のクラスが含まれているか調べる。
     * @param classValue
     * @return class属性に指定のクラスが含まれていればtrue
     */
    public boolean containsClassValue(String classValue);

    /**
     * 属性値を返す。
     * @param name
     * @return 属性があれば(値がnullであっても)true。nameで指定した属性がなかった場合、または属性値がnullの場合はnull
     */
    public String getAttribute(String name);

    /**
     * 要素の属性を設定する。
     * 文字列はエスケープされる。
     * @param name String
     * @param value String
     */
    public void setAttribute(String name, String value);

    public boolean hasAttribute();

    /**
     * 指定の名前の属性があるかどうか調べる。
     * @param name
     * @return nameで指定した属性があればtrue
     */
    public boolean hasAttribute(String name);

    public void removeAttribute(String name);

    public String getTagName();

    /**
     * タグ名を設定する。
     * nullを指定するとタグ文字列が出力されなくなる。
     * @param name String
     */
    public void setTagName(String name);

    public boolean hasEndTag();

    /**
     * 終了タグが必要ならtrueをセットする。
     * @param v boolean
     */
    public void setEndTag(boolean v);

    /**
     * このノードを繰り返しコピーして、このノードの後ろに追加する。
     * ノードはディープコピーされる。。
     * @param n ノードを繰り返す数。0を指定するとこのノードツリーから削除する。
     * 1を指定したときは何もしない。2以上を指定したときはn-1個のコピーを追加する。
     * @return このノードを含むコピーしたノードの配列。配列の長さはnとなる。
     */
    public HTMLElement[] repeat(int n);

}