/*
 * $Id: CheckBox.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/12/17
 */
package feat2.template.form;

import java.util.ArrayList;
import java.util.List;

import feat2.template.HTMLElement;

/**
 * フォームのチェックボックス。
 * @author SUGIMOTO Ken-ichi
 */
public class CheckBox implements FormControl {

    private HTMLElement[] elements;

    CheckBox(HTMLElement[] elements) {
        this.elements = elements;
    }

    /**
     * 名前を共有しているチェックボックスの要素を返す。
     * @return
     */
    public HTMLElement[] getElements() {
        return elements;
    }

    /**
     * 選択されたチェックボックスを返す。
     * @return 要素の配列。選択されたチェックボックスがない場合は空の配列を返す。
     */
    public HTMLElement[] getSelectedElements() {
        List list = new ArrayList();
        for(int i=0; i<elements.length; i++) {
            if ( elements[i].hasAttribute("checked") ) {
                list.add(elements[i]);
            }
        }
        return (HTMLElement[])list.toArray(new HTMLElement[list.size()]);
    }

    public void setValue(String value) {

        // value属性が引数と同じならchecked属性をつける

        for(int i=0; i<elements.length; i++) {

            String attrVal = elements[i].getAttribute("value");
            if ( attrVal != null && value != null && attrVal.equals(value) ) {
                elements[i].setAttribute("checked", null);
            }

        }

    }

    public void setValues(String[] values) {

        // すべてクリアする

        for(int i=0; i<elements.length; i++) {
            elements[i].removeAttribute("checked");
        }

        // 値を入力する

        if ( values != null && values.length > 0 )
            for(int i=0; i<values.length; i++)
                setValue(values[i]);
    }

    public String getValue() {
        String[] values = getValues();
        if ( values.length > 0 )
            return values[0];
        else
            return null;
    }

    public String[] getValues() {
        HTMLElement[] selected = getSelectedElements();
        List list = new ArrayList();
        for(int i=0; i<selected.length; i++) {
            list.add(selected[i].getValue());
        }
        return (String[])list.toArray(new String[list.size()]);
    }

    public HTMLElement getElement() {
        if ( elements.length > 0 )
            return elements[0];
        else
            return null;
    }

    public int getType() {
        return TYPE_CHECKBOX;
    }

}
