/*
 * $Id: HTMLNodeListImpl.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/07/29
 */
package feat2.template.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;


/**
 * 順序持ったノードのリスト。
 * featテンプレートAPIとDOM APIの両方で使用できる。
 * @author SUGIMOTO
 */
public class HTMLNodeListImpl implements NodeList, HTMLNodeList {

    private List list;

    public HTMLNodeListImpl() {
        list = new ArrayList();
    }

    public void add(HTMLNode node) {
        list.add(node);
    }

    public int size() {
        return list.size();
    }

    public HTMLNode get(int index) {
        return (HTMLNode)list.get(index);
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(list).iterator();
    }


    // NodeListの実装

    public int getLength() {
        return size();
    }

    public Node item(int index) {
        return TemplateUtil.toDomNode(get(index));
    }
}
