/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/8/22
 */

package feat2.template.impl;

import feat2.config.FileLocator;
import feat2.template.HTMLDocument;
import feat2.template.HTMLTemplate;

public class HTMLTemplateImpl implements HTMLTemplate {

    //private static Log log = LogFactory.getLog(HTMLTemplateImpl.class);

    private HTMLDocument document;
    private FileLocator locator;
    private String encoding;

    /**
     * @param locator テンプレートのファイル位置
     * @param encoding 文字コード
     * @param document ロード済みのテンプレート
     */
    HTMLTemplateImpl(FileLocator locator, String encoding, HTMLDocument document) {
        this.locator = locator;
        this.encoding = encoding;
        this.document = document;
    }

    /**
     * テンプレートのコピーを返す。
     * このメソッドはスレッドセーフ。
     * @return feat.html.HTMLTagNode
     */
    synchronized public HTMLDocument getDocument() {
        return (HTMLDocument)document.copy(true);
    }

    public FileLocator getLocation() {
        return locator;
    }

    public String getEncoding() {
        return encoding;
    }

}
