/*
 * $Id: ValidatorUtil.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/09
 */
package feat2.validation;

import org.apache.commons.validator.GenericValidator;

/**
 * バリデータのためのユーティリティクラス。
 * @author SUGIMOTO Ken-ichi
 */
public class ValidatorUtil {

    /**
     * 配列のすべてのソース値がnullまたは空だったらtrueを返す。
     * @param values
     * @return
     */
    public static boolean isBlankOrNull(String[] values) {

        if ( values == null )
            return true;

        boolean ret = true;

        for (int i = 0; i < values.length; i++) {
            ret = ( ret && GenericValidator.isBlankOrNull(values[i]) );
        }

        return ret;

    }

    public static boolean isBlankOrNull(String str) {
        return GenericValidator.isBlankOrNull(str);
    }

    /**
     * 配列の最初のn個すべてに値が入っていたらtrue。
     * @param values
     * @param n
     * @return
     */
    public static boolean isNotBlank(String[] values, int n) {

        if ( values == null || values.length == 0 )
            return false;

        boolean ret = true;

        if ( values.length < n )
            n = values.length;

        for (int i = 0; i < n; i++) {
            ret = ( ret && !GenericValidator.isBlankOrNull(values[i]) );
        }

        return ret;

    }


    public static boolean equalOrNull(Object a, Object b) {
        if ( a == null && b == null )
            return true;
        return a.equals(b);
    }

    /*public static void main(String[] args) {
        System.out.println(isJavaIdentifierPath("aaa.bbb.c_cc"));
    }*/

}
