/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.dialect.impl;

import java.nio.charset.Charset;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.selector.CharsetSelector;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public abstract class AbstractDialect
implements MobyletDialect {
    protected CharsetSelector charsetSelector = SingletonUtils.get(CharsetSelector.class);
    protected String contentTypeString = null;
    protected String xContentTypeString = null;

    protected AbstractDialect() {
    }

    @Override
    public String getCharsetName() {
        return SingletonUtils.get(CharsetSelector.class).getCharsetName(this.getCarrier());
    }

    @Override
    public Charset getCharset() {
        return SingletonUtils.get(CharsetSelector.class).getCharset(this.getCarrier());
    }

    @Override
    public String getContentCharsetName() {
        return this.getCharsetName();
    }

    @Override
    public String getCharacterEncodingCharsetName() {
        return SingletonUtils.get(CharsetSelector.class).getCharacterEncodingCharsetName(this.getCarrier());
    }

    @Override
    public String getContentTypeString() {
        if (StringUtils.isEmpty(this.contentTypeString)) {
            this.contentTypeString = "text/html; charset=" + this.getContentCharsetName();
        }
        return this.contentTypeString;
    }

    @Override
    public String getXContentTypeString() {
        if (StringUtils.isEmpty(this.xContentTypeString)) {
            this.xContentTypeString = "application/xhtml+xml; charset=" + this.getContentCharsetName();
        }
        return this.xContentTypeString;
    }
}

