/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.impl;

import org.mobylet.core.Carrier;
import org.mobylet.core.Mobylet;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.detector.CarrierDetector;
import org.mobylet.core.device.Device;
import org.mobylet.core.device.DeviceDisplay;
import org.mobylet.core.device.DevicePool;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.gps.Gps;
import org.mobylet.core.http.MobyletContext;
import org.mobylet.core.selector.DialectSelector;
import org.mobylet.core.type.ContentType;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;

public class MobyletImpl
implements Mobylet {
    protected Carrier carrier;
    protected MobyletDialect dialect;
    protected Device device;
    protected ContentType contentType;
    protected boolean isPopedDevice = false;
    protected boolean isPopedGps = false;

    public MobyletImpl() {
        this.initialize();
    }

    @Override
    public Carrier getCarrier() {
        return this.carrier;
    }

    @Override
    public MobyletDialect getDialect() {
        return this.dialect;
    }

    @Override
    public Device getDevice() {
        if (!this.isPopedDevice) {
            this.device = SingletonUtils.get(DevicePool.class).get();
            if (this.device != null) {
                RequestUtils.getMobyletContext().set(this.device);
            }
            this.isPopedDevice = true;
        }
        return this.device;
    }

    @Override
    public boolean hasCookies() {
        return RequestUtils.get().getCookies() != null;
    }

    @Override
    public String getUid() {
        return this.dialect.getUid();
    }

    @Override
    public String getGuid() {
        return this.dialect.getGuid();
    }

    @Override
    public Gps getGps() {
        MobyletContext context = RequestUtils.getMobyletContext();
        Gps g = context.get(Gps.class);
        if (this.isPopedGps) {
            return g;
        }
        g = this.dialect.getGps();
        context.set(g);
        this.isPopedGps = true;
        return this.getGps();
    }

    @Override
    public DeviceDisplay getDisplay() {
        Device device = null;
        DeviceDisplay dp = null;
        device = this.getDevice();
        if (device != null) {
            dp = device.getDeviceDisplay();
        }
        if (dp == null) {
            dp = this.dialect.getDeviceDisplayByRequestHeader();
        }
        return dp;
    }

    @Override
    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public ContentType getContentType() {
        if (this.contentType == null) {
            MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
            this.contentType = config.getContentType();
        }
        return this.contentType;
    }

    protected void initialize() {
        this.carrier = SingletonUtils.get(CarrierDetector.class).getCarrier();
        this.dialect = SingletonUtils.get(DialectSelector.class).getDialect(this.carrier);
    }
}

