/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.selector.impl;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mobylet.charset.MobyletCharsetPool;
import org.mobylet.core.Carrier;
import org.mobylet.core.selector.CharsetSelector;
import org.mobylet.core.util.SingletonUtils;

public class MobyletCharsetSelector
implements CharsetSelector {
    protected boolean isCharsetInstalled = false;
    protected boolean isCharsetNativeInstalled = false;
    protected Map<Carrier, Charset> charsetMap;

    public MobyletCharsetSelector() {
        this.initialize();
    }

    @Override
    public Charset getCharset(Carrier carrier) {
        if (this.isCharsetInstalled) {
            return this.charsetMap.get((Object)carrier);
        }
        return this.charsetMap.get((Object)Carrier.OTHER);
    }

    @Override
    public String getCharacterEncodingCharsetName(Carrier carrier) {
        if (this.isCharsetNativeInstalled) {
            return this.getCharsetName(carrier);
        }
        switch (carrier) {
            case DOCOMO: 
            case AU: {
                return "windows-31j";
            }
        }
        return this.getCharsetName(carrier);
    }

    @Override
    public String getCharsetName(Carrier carrier) {
        return this.getCharset(carrier).name();
    }

    @Override
    public boolean isCharsetInstalled() {
        return this.isCharsetInstalled;
    }

    protected void initialize() {
        this.charsetMap = new HashMap<Carrier, Charset>();
        Charset defCharset = SingletonUtils.get(Charset.class);
        if (defCharset == null) {
            defCharset = Charset.forName("windows-31j");
        }
        this.charsetMap.put(Carrier.OTHER, defCharset);
        try {
            this.charsetMap.put(Carrier.DOCOMO, MobyletCharsetPool.getInstance().charsetForName("x-mobylet-docomo"));
            this.charsetMap.put(Carrier.AU, MobyletCharsetPool.getInstance().charsetForName("x-mobylet-au"));
            this.charsetMap.put(Carrier.SOFTBANK, Charset.forName("utf-8"));
            this.isCharsetInstalled = true;
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.WARNING, "CHARSET IS NOT INSTALLED", t);
            this.isCharsetInstalled = false;
        }
        try {
            Charset.forName("x-mobylet-docomo");
            Charset.forName("x-mobylet-au");
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.INFO, "CHARSET IS NATIVE INSTALLED");
            this.isCharsetNativeInstalled = true;
        }
        catch (Throwable t) {
            this.isCharsetNativeInstalled = false;
        }
    }
}

