/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.css;

import java.util.HashMap;
import java.util.Map;
import org.mobylet.core.util.StringUtils;
import org.mobylet.view.css.SelectorType;
import org.mobylet.view.css.XhtmlNode;

public class CSSCond {
    protected String tag;
    protected String styleId;
    protected String styleClass;
    protected CSSCond parent;
    protected SelectorType selectorType;
    protected Map<String, String> valueMap;

    public CSSCond(String key) {
        if (key == null) {
            return;
        }
        if (key.endsWith(":first-child")) {
            key = key.substring(0, key.lastIndexOf(58));
            this.selectorType = SelectorType.FIRST_CHILD;
        }
        int dot = key.indexOf(46);
        int shp = key.indexOf(35);
        if (dot < 0 && shp < 0) {
            this.tag = key;
        } else if (dot >= 0 && shp < 0) {
            this.styleClass = key.substring(dot + 1);
            if (dot > 0) {
                this.tag = key.substring(0, dot);
            }
        } else if (dot < 0 && shp >= 0) {
            this.styleId = key.substring(shp + 1);
            if (shp > 0) {
                this.tag = key.substring(0, shp);
            }
        }
        this.valueMap = new HashMap<String, String>();
    }

    public void putStyle(String key, String value) {
        if (StringUtils.isNotEmpty(key) && StringUtils.isNotEmpty(value)) {
            this.valueMap.put(key.trim(), value.trim());
        }
    }

    public boolean matchAllParent(XhtmlNode node) {
        if (node == null) {
            return false;
        }
        boolean isMatch = false;
        while (!(isMatch = this.match(node.getParent())) && (node = node.getParent()) != null) {
        }
        return isMatch;
    }

    public boolean match(XhtmlNode node) {
        if (node == null) {
            return false;
        }
        boolean match = false;
        boolean unmatch = false;
        if (StringUtils.isNotEmpty(this.tag)) {
            if (this.tag.equals("*") || this.tag.equals(node.getTag())) {
                match = true;
            } else {
                unmatch = true;
            }
        }
        if (StringUtils.isNotEmpty(this.styleId)) {
            if (this.styleId.equals(node.getStyleId())) {
                match = true;
            } else {
                unmatch = true;
            }
        }
        if (StringUtils.isNotEmpty(this.styleClass)) {
            if (node.getStyleClasses() != null && node.getStyleClasses().contains(this.styleClass)) {
                match = true;
            } else {
                unmatch = true;
            }
        }
        if (this.selectorType != null && this.selectorType == SelectorType.FIRST_CHILD) {
            if (node.getIndex() == 1) {
                match = true;
            } else {
                unmatch = true;
            }
        }
        if (match && !unmatch && (this.selectorType == SelectorType.CHILD || this.selectorType == SelectorType.FIRST_CHILD)) {
            return this.parent == null || this.parent.match(node.getParent());
        }
        if (match && !unmatch) {
            return this.parent == null || this.parent.matchAllParent(node);
        }
        return false;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public CSSCond getParent() {
        return this.parent;
    }

    public void setParent(CSSCond parent) {
        this.parent = parent;
    }

    public SelectorType getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorType(SelectorType selectorType) {
        this.selectorType = selectorType;
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map<String, String> valueMap) {
        this.valueMap = valueMap;
    }
}

