/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XLog {
    private static final Log _log = LogFactory.getLog(XLog.class);
    protected static boolean _executeStatusLogLevelInfo;
    protected static boolean _locked;

    public static void log(String msg) {
        if (XLog.isExecuteStatusLogLevelInfo()) {
            _log.info((Object)msg);
        } else {
            _log.debug((Object)msg);
        }
    }

    public static boolean isLogEnabled() {
        if (XLog.isExecuteStatusLogLevelInfo()) {
            return _log.isInfoEnabled();
        }
        return _log.isDebugEnabled();
    }

    protected static boolean isExecuteStatusLogLevelInfo() {
        return _executeStatusLogLevelInfo;
    }

    public static void setExecuteStatusLogLevelInfo(boolean executeStatusLogLevelInfo) {
        XLog.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting executeStatusLogLevelInfo: " + executeStatusLogLevelInfo));
        }
        _executeStatusLogLevelInfo = executeStatusLogLevelInfo;
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Locking the log object for execute status!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Unlocking the log object for execute status!");
        }
        _locked = false;
    }

    protected static void assertNotLocked() {
        if (!XLog.isLocked()) {
            return;
        }
        String msg = "The QLog is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    static {
        _locked = true;
    }
}

