/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.OutsideSqlSelectListCommand;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlEntityExecutor<PARAMETER_BEAN> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final String _tableDbName;
    protected DBDef _currentDBDef;

    public OutsideSqlEntityExecutor(BehaviorCommandInvoker behaviorCommandInvoker, OutsideSqlOption outsideSqlOption, String tableDbName, DBDef currentDBDef) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._outsideSqlOption = outsideSqlOption;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
    }

    public <ENTITY> ENTITY selectEntity(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        List<ENTITY> ls = this.invoke(this.createSelectListCommand(path, pmb, entityType));
        if (ls.isEmpty()) {
            return null;
        }
        if (ls.size() > 1) {
            this.throwEntityDuplicatedException(ls.size() + "", this.buildSearch4LogString(path, pmb, entityType), null);
        }
        return ls.get(0);
    }

    public <ENTITY> ENTITY selectEntityWithDeletedCheck(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        List<ENTITY> ls = this.invoke(this.createSelectListCommand(path, pmb, entityType));
        if (ls == null || ls.isEmpty()) {
            this.throwEntityAlreadyDeletedException(this.buildSearch4LogString(path, pmb, entityType));
        }
        if (ls.size() > 1) {
            this.throwEntityDuplicatedException(ls.size() + "", this.buildSearch4LogString(path, pmb, entityType), null);
        }
        return ls.get(0);
    }

    protected <ENTITY> String buildSearch4LogString(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        String tmp = "Table  = " + this._outsideSqlOption.getTableDbName() + OutsideSqlEntityExecutor.getLineSeparator();
        tmp = tmp + "Path   = " + path + OutsideSqlEntityExecutor.getLineSeparator();
        tmp = tmp + "Pmb    = " + (pmb != null ? pmb.getClass().getSimpleName() : "null") + ":" + pmb + OutsideSqlEntityExecutor.getLineSeparator();
        tmp = tmp + "Entity = " + (entityType != null ? entityType.getSimpleName() : "null") + OutsideSqlEntityExecutor.getLineSeparator();
        tmp = tmp + "Option = " + this._outsideSqlOption;
        return tmp;
    }

    protected void throwEntityAlreadyDeletedException(Object searchKey4Log) {
        ConditionBeanContext.throwEntityAlreadyDeletedException(searchKey4Log);
    }

    protected void throwEntityDuplicatedException(String resultCountString, Object searchKey4Log, Throwable cause) {
        ConditionBeanContext.throwEntityDuplicatedException(resultCountString, searchKey4Log, cause);
    }

    protected <ENTITY> BehaviorCommand<List<ENTITY>> createSelectListCommand(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        return this.xsetupCommand(new OutsideSqlSelectListCommand(), path, pmb, entityType);
    }

    private <ENTITY> OutsideSqlSelectListCommand<ENTITY> xsetupCommand(OutsideSqlSelectListCommand<ENTITY> command, String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        command.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setOutsideSqlPath(path);
        command.setParameterBean(pmb);
        command.setOutsideSqlOption(this._outsideSqlOption);
        command.setCurrentDBDef(this._currentDBDef);
        command.setEntityType(entityType);
        return command;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> dynamicBinding() {
        this._outsideSqlOption.dynamicBinding();
        return this;
    }

    protected static String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }
}

