/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.util.Map;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnDtoMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnPropertyTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnDtoMetaDataImpl
implements TnDtoMetaData {
    protected Class<?> beanClass;
    protected StringKeyMap<TnPropertyType> propertyTypeMap = StringKeyMap.createAsCaseInsensitiveConcurrent();
    protected TnBeanAnnotationReader beanAnnotationReader;
    protected TnPropertyTypeFactory propertyTypeFactory;

    public void initialize() {
        this.setupPropertyType();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Map<String, TnPropertyType> getPropertyTypeMap() {
        return this.propertyTypeMap;
    }

    @Override
    public TnPropertyType getPropertyType(String propertyName) {
        TnPropertyType propertyType = this.propertyTypeMap.get(propertyName);
        if (propertyType == null) {
            String msg = "The propertyName was not found in the map:";
            msg = msg + " propertyName=" + propertyName + " propertyTypeMap=" + this.propertyTypeMap;
            throw new IllegalStateException(msg);
        }
        return propertyType;
    }

    @Override
    public boolean hasPropertyType(String propertyName) {
        return this.propertyTypeMap.get(propertyName) != null;
    }

    protected void setupPropertyType() {
        TnPropertyType[] propertyTypes = this.propertyTypeFactory.createDtoPropertyTypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            this.addPropertyType(pt);
        }
    }

    protected void addPropertyType(TnPropertyType propertyType) {
        this.propertyTypeMap.put(propertyType.getPropertyName(), propertyType);
    }

    public void setBeanAnnotationReader(TnBeanAnnotationReader beanAnnotationReader) {
        this.beanAnnotationReader = beanAnnotationReader;
    }

    public void setPropertyTypeFactory(TnPropertyTypeFactory propertyTypeFactory) {
        this.propertyTypeFactory = propertyTypeFactory;
    }
}

