/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.factory.TnBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.impl.TnRelationPropertyTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnRelationPropertyTypeFactoryImpl
implements TnRelationPropertyTypeFactory {
    protected Class<?> beanClass;
    protected TnBeanAnnotationReader beanAnnotationReader;
    protected TnBeanMetaDataFactory beanMetaDataFactory;
    protected DatabaseMetaData databaseMetaData;
    protected int relationNestLevel;
    protected boolean isStopRelationCreation;

    public TnRelationPropertyTypeFactoryImpl(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader, TnBeanMetaDataFactory beanMetaDataFactory, DatabaseMetaData databaseMetaData, int relationNestLevel, boolean isStopRelationCreation) {
        this.beanClass = beanClass;
        this.beanAnnotationReader = beanAnnotationReader;
        this.beanMetaDataFactory = beanMetaDataFactory;
        this.databaseMetaData = databaseMetaData;
        this.relationNestLevel = relationNestLevel;
        this.isStopRelationCreation = isStopRelationCreation;
    }

    @Override
    public TnRelationPropertyType[] createRelationPropertyTypes() {
        ArrayList<TnRelationPropertyType> list = new ArrayList<TnRelationPropertyType>();
        TnBeanDesc beanDesc = this.getBeanDesc();
        List<String> proppertyNameList = beanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            TnPropertyDesc pd = beanDesc.getPropertyDesc(proppertyName);
            if (this.isStopRelationCreation || !this.isRelationProperty(pd)) continue;
            TnRelationPropertyType rpt = this.createRelationPropertyType(pd);
            list.add(rpt);
        }
        return list.toArray(new TnRelationPropertyType[list.size()]);
    }

    protected TnRelationPropertyType createRelationPropertyType(TnPropertyDesc propertyDesc) {
        String[] myKeys = new String[]{};
        String[] yourKeys = new String[]{};
        int relno = this.beanAnnotationReader.getRelationNo(propertyDesc);
        String relkeys = this.beanAnnotationReader.getRelationKey(propertyDesc);
        if (relkeys != null) {
            StringTokenizer st = new StringTokenizer(relkeys, " \t\n\r\f,");
            ArrayList<String> myKeyList = new ArrayList<String>();
            ArrayList<String> yourKeyList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(58);
                if (index > 0) {
                    myKeyList.add(token.substring(0, index));
                    yourKeyList.add(token.substring(index + 1));
                    continue;
                }
                myKeyList.add(token);
                yourKeyList.add(token);
            }
            myKeys = myKeyList.toArray(new String[myKeyList.size()]);
            yourKeys = yourKeyList.toArray(new String[yourKeyList.size()]);
        }
        TnBeanMetaData beanMetaData = this.createRelationBeanMetaData(propertyDesc.getPropertyType());
        TnPropertyDesc pd = propertyDesc;
        TnRelationPropertyTypeImpl rpt = new TnRelationPropertyTypeImpl(pd, relno, myKeys, yourKeys, beanMetaData);
        return rpt;
    }

    protected TnBeanMetaData createRelationBeanMetaData(Class<?> relationBeanClass) {
        return this.beanMetaDataFactory.createBeanMetaData(this.databaseMetaData, relationBeanClass, this.relationNestLevel + 1);
    }

    protected boolean isRelationProperty(TnPropertyDesc propertyDesc) {
        return this.beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected TnBeanDesc getBeanDesc() {
        return TnBeanDescFactory.getBeanDesc(this.beanClass);
    }
}

