/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.procedure;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.seasar.dbflute.s2dao.procedure.TnProcedureParameterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnProcedureMetaData {
    private String procedureName;
    private Map<String, TnProcedureParameterType> unorderedMap = this.createUnorderedMap();
    private Map<String, TnProcedureParameterType> parameterTypes = this.createParameterTypes();
    private boolean returnType;

    public TnProcedureMetaData(String procedureName) {
        this.procedureName = procedureName;
    }

    protected Map<String, TnProcedureParameterType> createUnorderedMap() {
        return new HashMap<String, TnProcedureParameterType>();
    }

    protected Map<String, TnProcedureParameterType> createParameterTypes() {
        return new TreeMap<String, TnProcedureParameterType>(new ParameterComparator());
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public Collection<TnProcedureParameterType> parameterTypes() {
        return this.parameterTypes.values();
    }

    public void addParameterType(TnProcedureParameterType parameterType) {
        String name = parameterType.getParameterName();
        this.unorderedMap.put(name, parameterType);
        this.parameterTypes.put(name, parameterType);
        if (parameterType.isReturnType()) {
            this.returnType = true;
        }
    }

    public boolean hasReturnParameterType() {
        return this.returnType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ParameterComparator
    implements Comparator<String> {
        protected ParameterComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            boolean oneGreaterThanTwo = true;
            int twoGreaterThanOne = -1;
            TnProcedureParameterType parameterType1 = (TnProcedureParameterType)TnProcedureMetaData.this.unorderedMap.get(o1);
            TnProcedureParameterType parameterType2 = (TnProcedureParameterType)TnProcedureMetaData.this.unorderedMap.get(o2);
            if (parameterType1.isReturnType()) {
                return -1;
            }
            if (parameterType2.isReturnType()) {
                return 1;
            }
            Integer parameterIndex1 = parameterType1.getParameterIndex();
            Integer parameterIndex2 = parameterType2.getParameterIndex();
            if (parameterIndex1 == null) {
                if (parameterIndex2 == null) {
                    return 1;
                }
                return 1;
            }
            if (parameterIndex2 == null) {
                return -1;
            }
            return parameterIndex1.compareTo(parameterIndex2);
        }
    }
}

