/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.plugin;

import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.dbflute.util.DfResourceUtil;
import org.seasar.dbflute.util.DfTypeUtil;

public class TnStringClobType
extends TnAbstractValueType {
    public TnStringClobType() {
        super(2005);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.convertToString(resultSet.getCharacterStream(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.convertToString(resultSet.getCharacterStream(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.convertToString(cs.getClob(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.convertToString(cs.getClob(parameterName));
    }

    protected String convertToString(Reader reader) {
        if (reader == null) {
            return null;
        }
        return DfResourceUtil.readText(reader);
    }

    protected String convertToString(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        return this.convertToString(clob.getCharacterStream());
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            String s = DfTypeUtil.toString(value);
            ps.setCharacterStream(index, (Reader)new StringReader(s), s.length());
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            String s = DfTypeUtil.toString(value);
            cs.setCharacterStream(parameterName, (Reader)new StringReader(s), s.length());
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return DfTypeUtil.nullText();
        }
        String var = DfTypeUtil.toString(value);
        return DfTypeUtil.toText(var);
    }
}

