/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.SolrInputField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrInputDocument
implements Iterable<SolrInputField>,
Serializable {
    private final Map<String, SolrInputField> _fields = new LinkedHashMap<String, SolrInputField>();
    private float _documentBoost = 1.0f;

    public void clear() {
        if (this._fields != null) {
            this._fields.clear();
        }
    }

    public void addField(String name, Object value) {
        this.addField(name, value, 1.0f);
    }

    public Object getFieldValue(String name) {
        SolrInputField field = this.getField(name);
        Object o = null;
        if (field != null) {
            o = field.getFirstValue();
        }
        return o;
    }

    public Collection<Object> getFieldValues(String name) {
        SolrInputField field = this.getField(name);
        if (field != null) {
            return field.getValues();
        }
        return null;
    }

    public Collection<String> getFieldNames() {
        return this._fields.keySet();
    }

    public void setField(String name, Object value) {
        this.setField(name, value, 1.0f);
    }

    public void setField(String name, Object value, float boost) {
        SolrInputField field = new SolrInputField(name);
        this._fields.put(name, field);
        field.setValue(value, boost);
    }

    public void addField(String name, Object value, float boost) {
        SolrInputField field = this._fields.get(name);
        if (field == null || field.value == null) {
            this.setField(name, value, boost);
        } else {
            field.addValue(value, boost);
        }
    }

    public SolrInputField removeField(String name) {
        return this._fields.remove(name);
    }

    public SolrInputField getField(String field) {
        return this._fields.get(field);
    }

    @Override
    public Iterator<SolrInputField> iterator() {
        return this._fields.values().iterator();
    }

    public float getDocumentBoost() {
        return this._documentBoost;
    }

    public void setDocumentBoost(float documentBoost) {
        this._documentBoost = documentBoost;
    }

    public String toString() {
        return "SolrInputDocumnt[" + this._fields + "]";
    }
}

