/*
 * Decompiled with CFR 0.152.
 */
package org.junit.samples.money;

import junit.framework.JUnit4TestAdapter;
import junit.samples.money.IMoney;
import junit.samples.money.Money;
import junit.samples.money.MoneyBag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MoneyTest {
    private Money f12CHF;
    private Money f14CHF;
    private Money f7USD;
    private Money f21USD;
    private IMoney fMB1;
    private IMoney fMB2;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(MoneyTest.class);
    }

    @Before
    public void setUp() {
        this.f12CHF = new Money(12, "CHF");
        this.f14CHF = new Money(14, "CHF");
        this.f7USD = new Money(7, "USD");
        this.f21USD = new Money(21, "USD");
        this.fMB1 = MoneyBag.create((IMoney)this.f12CHF, (IMoney)this.f7USD);
        this.fMB2 = MoneyBag.create((IMoney)this.f14CHF, (IMoney)this.f21USD);
    }

    @Test
    public void testBagMultiply() {
        IMoney expected = MoneyBag.create((IMoney)new Money(24, "CHF"), (IMoney)new Money(14, "USD"));
        Assert.assertEquals(expected, this.fMB1.multiply(2));
        Assert.assertEquals(this.fMB1, this.fMB1.multiply(1));
        Assert.assertTrue(this.fMB1.multiply(0).isZero());
    }

    @Test
    public void testBagNegate() {
        IMoney expected = MoneyBag.create((IMoney)new Money(-12, "CHF"), (IMoney)new Money(-7, "USD"));
        Assert.assertEquals(expected, this.fMB1.negate());
    }

    @Test
    public void testBagSimpleAdd() {
        IMoney expected = MoneyBag.create((IMoney)new Money(26, "CHF"), (IMoney)new Money(7, "USD"));
        Assert.assertEquals(expected, this.fMB1.add((IMoney)this.f14CHF));
    }

    @Test
    public void testBagSubtract() {
        IMoney expected = MoneyBag.create((IMoney)new Money(-2, "CHF"), (IMoney)new Money(-14, "USD"));
        Assert.assertEquals(expected, this.fMB1.subtract(this.fMB2));
    }

    @Test
    public void testBagSumAdd() {
        IMoney expected = MoneyBag.create((IMoney)new Money(26, "CHF"), (IMoney)new Money(28, "USD"));
        Assert.assertEquals(expected, this.fMB1.add(this.fMB2));
    }

    @Test
    public void testIsZero() {
        Assert.assertTrue(this.fMB1.subtract(this.fMB1).isZero());
        Assert.assertTrue(MoneyBag.create((IMoney)new Money(0, "CHF"), (IMoney)new Money(0, "USD")).isZero());
    }

    @Test
    public void testMixedSimpleAdd() {
        IMoney expected = MoneyBag.create((IMoney)this.f12CHF, (IMoney)this.f7USD);
        Assert.assertEquals(expected, this.f12CHF.add((IMoney)this.f7USD));
    }

    @Test
    public void testBagNotEquals() {
        IMoney bag = MoneyBag.create((IMoney)this.f12CHF, (IMoney)this.f7USD);
        Assert.assertFalse(bag.equals(new Money(12, "DEM").add((IMoney)this.f7USD)));
    }

    @Test
    public void testMoneyBagEquals() {
        Assert.assertTrue(!this.fMB1.equals(null));
        Assert.assertEquals(this.fMB1, this.fMB1);
        IMoney equal = MoneyBag.create((IMoney)new Money(12, "CHF"), (IMoney)new Money(7, "USD"));
        Assert.assertTrue(this.fMB1.equals(equal));
        Assert.assertTrue(!this.fMB1.equals(this.f12CHF));
        Assert.assertTrue(!this.f12CHF.equals((Object)this.fMB1));
        Assert.assertTrue(!this.fMB1.equals(this.fMB2));
    }

    @Test
    public void testMoneyBagHash() {
        IMoney equal = MoneyBag.create((IMoney)new Money(12, "CHF"), (IMoney)new Money(7, "USD"));
        Assert.assertEquals(this.fMB1.hashCode(), equal.hashCode());
    }

    @Test
    public void testMoneyEquals() {
        Assert.assertTrue(!this.f12CHF.equals(null));
        Money equalMoney = new Money(12, "CHF");
        Assert.assertEquals(this.f12CHF, this.f12CHF);
        Assert.assertEquals(this.f12CHF, equalMoney);
        Assert.assertEquals(this.f12CHF.hashCode(), equalMoney.hashCode());
        Assert.assertTrue(!this.f12CHF.equals((Object)this.f14CHF));
    }

    @Test
    public void zeroMoniesAreEqualRegardlessOfCurrency() {
        Money zeroDollars = new Money(0, "USD");
        Money zeroFrancs = new Money(0, "CHF");
        Assert.assertEquals(zeroDollars, zeroFrancs);
        Assert.assertEquals(zeroDollars.hashCode(), zeroFrancs.hashCode());
    }

    @Test
    public void testMoneyHash() {
        Assert.assertTrue(!this.f12CHF.equals(null));
        Money equal = new Money(12, "CHF");
        Assert.assertEquals(this.f12CHF.hashCode(), equal.hashCode());
    }

    @Test
    public void testSimplify() {
        IMoney money = MoneyBag.create((IMoney)new Money(26, "CHF"), (IMoney)new Money(28, "CHF"));
        Assert.assertEquals(new Money(54, "CHF"), money);
    }

    @Test
    public void testNormalize2() {
        Money expected = new Money(7, "USD");
        Assert.assertEquals(expected, this.fMB1.subtract((IMoney)this.f12CHF));
    }

    @Test
    public void testNormalize3() {
        IMoney ms1 = MoneyBag.create((IMoney)new Money(12, "CHF"), (IMoney)new Money(3, "USD"));
        Money expected = new Money(4, "USD");
        Assert.assertEquals(expected, this.fMB1.subtract(ms1));
    }

    @Test
    public void testNormalize4() {
        IMoney ms1 = MoneyBag.create((IMoney)new Money(12, "CHF"), (IMoney)new Money(3, "USD"));
        Money expected = new Money(-3, "USD");
        Assert.assertEquals(expected, this.f12CHF.subtract(ms1));
    }

    @Test
    public void testPrint() {
        Assert.assertEquals("[12 CHF]", this.f12CHF.toString());
    }

    @Test
    public void testSimpleAdd() {
        Money expected = new Money(26, "CHF");
        Assert.assertEquals(expected, this.f12CHF.add((IMoney)this.f14CHF));
    }

    @Test
    public void testSimpleBagAdd() {
        IMoney expected = MoneyBag.create((IMoney)new Money(26, "CHF"), (IMoney)new Money(7, "USD"));
        Assert.assertEquals(expected, this.f14CHF.add(this.fMB1));
    }

    @Test
    public void testSimpleMultiply() {
        Money expected = new Money(28, "CHF");
        Assert.assertEquals(expected, this.f14CHF.multiply(2));
    }

    @Test
    public void testSimpleNegate() {
        Money expected = new Money(-14, "CHF");
        Assert.assertEquals(expected, this.f14CHF.negate());
    }

    @Test
    public void testSimpleSubtract() {
        Money expected = new Money(2, "CHF");
        Assert.assertEquals(expected, this.f14CHF.subtract((IMoney)this.f12CHF));
    }
}

