/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class JUnitCoreTest {
    @Test
    public void failureCausesExitCodeOf1() throws Exception {
        this.runClass("org.junit.tests.JUnitCoreTest$Fail", 1);
    }

    @Test
    public void missingClassCausesExitCodeOf1() throws Exception {
        this.runClass("Foo", 1);
    }

    @Test
    public void successCausesExitCodeOf0() throws Exception {
        this.runClass("org.junit.tests.JUnitCoreTest$Succeed", 0);
    }

    private void runClass(String className, int returnCode) throws IOException, InterruptedException {
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classPath = this.getClass().getClassLoader().getResource(".").getFile() + File.pathSeparator + System.getProperty("java.class.path");
        String[] cmd = new String[]{java, "-cp", classPath, "org.junit.runner.JUnitCore", className};
        Process process = Runtime.getRuntime().exec(cmd);
        InputStream input = process.getInputStream();
        while (input.read() != -1) {
        }
        Assert.assertEquals(returnCode, process.waitFor());
    }

    public static class Succeed {
        @Test
        public void peacefulSilence() {
        }
    }

    public static class Fail {
        @Test
        public void kaboom() {
            Assert.fail();
        }
    }
}

