/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TestListenerTest {
    int count;

    @Test(expected=Error.class)
    public void failingListener() {
        JUnitCore runner = new JUnitCore();
        runner.addListener(new ErrorListener());
        runner.run(OneTest.class);
    }

    @Test
    public void removeFailingListeners() {
        JUnitCore core = new JUnitCore();
        core.addListener(new ExceptionListener());
        this.count = 0;
        Result result = core.run(OneTest.class);
        Assert.assertEquals(1, this.count);
        Assert.assertEquals(1, result.getFailureCount());
        Failure testFailure = result.getFailures().get(0);
        Assert.assertEquals(Description.TEST_MECHANISM, testFailure.getDescription());
        this.count = 0;
        core.run(OneTest.class);
        Assert.assertEquals(0, this.count);
    }

    @Test
    public void freshResultEachTime() {
        JUnitCore core = new JUnitCore();
        Result first = core.run(OneTest.class);
        Result second = core.run(OneTest.class);
        Assert.assertNotSame(first, second);
    }

    class ExceptionListener
    extends ErrorListener {
        ExceptionListener() {
        }

        public void testRunStarted(Description description) throws Exception {
            ++TestListenerTest.this.count;
            throw new Exception();
        }
    }

    public static class OneTest {
        @Test
        public void nothing() {
        }
    }

    class ErrorListener
    extends RunListener {
        ErrorListener() {
        }

        public void testRunStarted(Description description) throws Exception {
            throw new Error();
        }
    }
}

