/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestResult;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutTest {
    @Test
    public void failureWithTimeout() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(FailureWithTimeoutTest.class);
        Assert.assertEquals(1, result.getRunCount());
        Assert.assertEquals(1, result.getFailureCount());
        Assert.assertEquals(AssertionError.class, result.getFailures().get(0).getException().getClass());
    }

    @Test
    public void failureWithTimeoutRunTimeException() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(FailureWithTimeoutRunTimeExceptionTest.class);
        Assert.assertEquals(1, result.getRunCount());
        Assert.assertEquals(1, result.getFailureCount());
        Assert.assertEquals(NullPointerException.class, result.getFailures().get(0).getException().getClass());
    }

    @Test
    public void successWithTimeout() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(SuccessWithTimeoutTest.class);
        Assert.assertEquals(1, result.getRunCount());
        Assert.assertEquals(0, result.getFailureCount());
    }

    @Ignore(value="was breaking gump")
    @Test
    public void timeoutFailure() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(TimeoutFailureTest.class);
        Assert.assertEquals(1, result.getRunCount());
        Assert.assertEquals(1, result.getFailureCount());
        Assert.assertEquals(InterruptedException.class, result.getFailures().get(0).getException().getClass());
    }

    @Test
    public void infiniteLoop() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(InfiniteLoopTest.class);
        Assert.assertEquals(1, result.getRunCount());
        Assert.assertEquals(1, result.getFailureCount());
        Throwable exception = result.getFailures().get(0).getException();
        Assert.assertTrue(exception.getMessage().contains("test timed out after 100 milliseconds"));
    }

    @Ignore(value="This breaks sporadically with time differences just slightly more than 200ms")
    @Test
    public void infiniteLoopRunsForApproximatelyLengthOfTimeout() throws Exception {
        JUnitCore.runClasses(InfiniteLoopTest.class, ImpatientLoopTest.class);
        long longTime = this.runAndTime(InfiniteLoopTest.class);
        long shortTime = this.runAndTime(ImpatientLoopTest.class);
        long difference = longTime - shortTime;
        Assert.assertTrue(String.format("Difference was %sms", difference), difference < 200L);
    }

    private long runAndTime(Class<?> clazz) {
        JUnitCore core = new JUnitCore();
        long startTime = System.currentTimeMillis();
        core.run(clazz);
        long totalTime = System.currentTimeMillis() - startTime;
        return totalTime;
    }

    @Ignore(value="We would like this behavior to work but it may not be possible")
    @Test
    public void stalledThreadAppearsInStackTrace() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(InfiniteLoopTest.class);
        Assert.assertEquals(1, result.getRunCount());
        Assert.assertEquals(1, result.getFailureCount());
        Throwable exception = result.getFailures().get(0).getException();
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        exception.printStackTrace(writer);
        Assert.assertTrue(writer.toString().contains("infiniteLoop"));
    }

    @Test
    public void compatibility() {
        TestResult result = new TestResult();
        new JUnit4TestAdapter(InfiniteLoopTest.class).run(result);
        Assert.assertEquals(1, result.errorCount());
    }

    public static class ImpatientLoopTest {
        @Test(timeout=1L)
        public void failure() {
            this.infiniteLoop();
        }

        private void infiniteLoop() {
            while (true) {
                // Infinite loop
            }
        }
    }

    public static class InfiniteLoopTest {
        @Test(timeout=100L)
        public void failure() {
            this.infiniteLoop();
        }

        private void infiniteLoop() {
            while (true) {
                // Infinite loop
            }
        }
    }

    public static class TimeoutFailureTest {
        @Test(timeout=100L)
        public void success() throws InterruptedException {
            Thread.sleep(40000L);
        }
    }

    public static class SuccessWithTimeoutTest {
        @Test(timeout=1000L)
        public void success() {
        }
    }

    public static class FailureWithTimeoutRunTimeExceptionTest {
        @Test(timeout=1000L)
        public void failure() {
            throw new NullPointerException();
        }
    }

    public static class FailureWithTimeoutTest {
        @Test(timeout=1000L)
        public void failure() {
            Assert.fail();
        }
    }
}

