/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.valuetype;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.robot.dbflute.jdbc.Classification;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.BytesType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.OracleResultSetType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.PostgreResultSetType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.SerializableType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.BigDecimalType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.BigIntegerType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.BinaryStreamType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.BinaryType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.BooleanType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.ByteType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.CharacterType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.ClassificationType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.DoubleType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.FloatType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.IntegerType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.LongType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.ObjectType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.ShortType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.SqlDateType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.StringType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.TimeType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.TimestampType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.UUIDType;
import org.seasar.robot.dbflute.s2dao.valuetype.registered.UserDefineType;
import org.seasar.robot.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType BYTE = new ByteType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType BIGINTEGER = new BigIntegerType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType UUID = new UUIDType();
    public static final ValueType CLASSIFICATION = new ClassificationType();
    public static final ValueType OBJECT = new ObjectType();
    public static final ValueType ORACLE_RESULT_SET = new OracleResultSetType();
    public static final ValueType POSTGRE_RESULT_SET = new PostgreResultSetType();
    public static final ValueType SERIALIZABLE_BYTE_ARRAY = new SerializableType(BytesType.BYTES_TRAIT);
    private static final ValueType NULL = new NullType();
    private static final Class<?> BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static Map<Class<?>, ValueType> basicValueTypeMap = new ConcurrentHashMap();
    private static Map<String, ValueType> pluginValueTypeMap = new ConcurrentHashMap<String, ValueType>();
    private static Method isEnumMethod;
    private static Constructor<?> enumDefaultValueTypeConstructor;
    private static Constructor<?> enumOrdinalValueTypeConstructor;
    private static Constructor<?> enumStringValueTypeConstructor;
    private static Map<String, ValueType> valueTypeCache;

    protected TnValueTypes() {
    }

    public static void registerBasicValueType(Class<?> keyType, ValueType valueType) {
        TnValueTypes.assertObjectNotNull("keyType", keyType);
        TnValueTypes.assertObjectNotNull("valueType", valueType);
        basicValueTypeMap.put(keyType, valueType);
    }

    public static void removeBasicValueType(Class<?> keyType) {
        TnValueTypes.assertObjectNotNull("keyType", keyType);
        basicValueTypeMap.remove(keyType);
    }

    public static void registerPluginValueType(String keyName, ValueType valueType) {
        TnValueTypes.assertObjectNotNull("keyName", keyName);
        TnValueTypes.assertObjectNotNull("valueType", valueType);
        pluginValueTypeMap.put(keyName, valueType);
    }

    public static void removePluginValueType(String keyName) {
        TnValueTypes.assertObjectNotNull("keyName", keyName);
        pluginValueTypeMap.remove(keyName);
    }

    public static ValueType getValueType(Object obj) {
        if (obj == null) {
            return OBJECT;
        }
        return TnValueTypes.getValueType(obj.getClass());
    }

    public static ValueType getValueType(Class<?> clazz) {
        ValueType valueType;
        if (clazz == null) {
            return OBJECT;
        }
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            ValueType valueType2 = TnValueTypes.getRegisteredValueType(c);
            if (valueType2 == null) continue;
            return valueType2;
        }
        if (Classification.class.isAssignableFrom(clazz) && (valueType = TnValueTypes.getRegisteredValueType(Classification.class)) != null) {
            return valueType;
        }
        valueType = TnValueTypes.getCachedValueType(clazz);
        if (valueType != null) {
            return valueType;
        }
        return OBJECT;
    }

    private static ValueType getRegisteredValueType(Class<?> clazz) {
        return basicValueTypeMap.get(clazz);
    }

    public static ValueType getPluginValueType(String valueTypeName) {
        TnValueTypes.assertObjectNotNull("valueTypeName", valueTypeName);
        return pluginValueTypeMap.get(valueTypeName);
    }

    private static boolean hasCachedValueType(Class<?> clazz) {
        return TnValueTypes.getCachedValueType(clazz) != null;
    }

    private static ValueType getCachedValueType(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return null;
        }
        ValueType valueType = valueTypeCache.get(clazz.getName());
        if (valueType == NULL) {
            return null;
        }
        if (valueType != null) {
            return valueType;
        }
        Class<?> normalizedEnumClass = TnValueTypes.normalizeEnum(clazz);
        if (normalizedEnumClass != null) {
            valueType = TnValueTypes.getEnumDefaultValueType(normalizedEnumClass);
            valueTypeCache.put(normalizedEnumClass.getName(), valueType);
            return valueType;
        }
        valueType = TnValueTypes.createUserDefineValueType(clazz);
        if (valueType != null) {
            valueTypeCache.put(clazz.getName(), valueType);
            return valueType;
        }
        valueTypeCache.put(clazz.getName(), NULL);
        return null;
    }

    public static ValueType createUserDefineValueType(Class<?> clazz) {
        int i;
        ArrayList<Method> valueOfMethods = new ArrayList<Method>();
        Method valueMethod = null;
        Method[] methods = clazz.getMethods();
        for (i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method)) continue;
            int mod = method.getModifiers();
            if (method.getName().equals("valueOf") && method.getParameterTypes().length == 1 && method.getReturnType() == clazz && DfReflectionUtil.isPublic(mod) && DfReflectionUtil.isStatic(mod)) {
                valueOfMethods.add(method);
                continue;
            }
            if (!method.getName().equals("value") || method.getParameterTypes().length != 0 || !DfReflectionUtil.isPublic(mod) || DfReflectionUtil.isStatic(mod)) continue;
            valueMethod = method;
        }
        if (valueMethod == null) {
            return null;
        }
        for (i = 0; i < valueOfMethods.size(); ++i) {
            Method valueOfMethod = (Method)valueOfMethods.get(i);
            if (valueOfMethod.getParameterTypes()[0] != valueMethod.getReturnType()) continue;
            Class<?> baseClass = valueMethod.getReturnType();
            ValueType baseValueType = TnValueTypes.getRegisteredValueType(baseClass);
            if (baseValueType == null) {
                return null;
            }
            return new UserDefineType(baseValueType, valueOfMethod, valueMethod);
        }
        return null;
    }

    public static Class<?> getType(int sqltype) {
        switch (sqltype) {
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 91: {
                return Timestamp.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTE_ARRAY_CLASS;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public static ValueType getValueType(int sqltype) {
        return TnValueTypes.getValueType(TnValueTypes.getType(sqltype));
    }

    public static void setEnumDefaultValueType(Class<?> enumDefaultValueTypeClass) throws NoSuchMethodException {
        enumDefaultValueTypeConstructor = enumDefaultValueTypeClass.getConstructor(Class.class);
    }

    public static void setEnumOrdinalValueType(Class<?> enumOrdinalValueTypeClass) throws NoSuchMethodException {
        enumOrdinalValueTypeConstructor = enumOrdinalValueTypeClass.getConstructor(Class.class);
    }

    public static void setEnumStringValueType(Class<?> enumStringValueTypeClass) throws NoSuchMethodException {
        enumStringValueTypeConstructor = enumStringValueTypeClass.getConstructor(Class.class);
    }

    private static Class<?> normalizeEnum(Class<?> clazz) {
        if (isEnumMethod == null || enumStringValueTypeConstructor == null) {
            return null;
        }
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            if (!DfReflectionUtil.invoke(isEnumMethod, c, null).equals(Boolean.TRUE)) continue;
            return c;
        }
        return null;
    }

    public static ValueType getEnumDefaultValueType(Class<?> clazz) {
        return (ValueType)DfReflectionUtil.newInstance(enumDefaultValueTypeConstructor, new Class[]{clazz});
    }

    public static ValueType getEnumStringValueType(Class<?> clazz) {
        return (ValueType)DfReflectionUtil.newInstance(enumStringValueTypeConstructor, new Class[]{clazz});
    }

    public static ValueType getEnumOrdinalValueType(Class<?> clazz) {
        return (ValueType)DfReflectionUtil.newInstance(enumOrdinalValueTypeConstructor, new Class[]{clazz});
    }

    public static void clear() {
        valueTypeCache.clear();
    }

    public static boolean isSimpleType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return clazz == String.class || clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || Number.class.isAssignableFrom(clazz) || java.util.Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz) || clazz == BYTE_ARRAY_CLASS || TnValueTypes.hasCachedValueType(clazz);
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        valueTypeCache = new ConcurrentHashMap<String, ValueType>(50);
        TnValueTypes.registerBasicValueType(String.class, STRING);
        TnValueTypes.registerBasicValueType(Character.TYPE, CHARACTER);
        TnValueTypes.registerBasicValueType(Character.class, CHARACTER);
        TnValueTypes.registerBasicValueType(Byte.TYPE, BYTE);
        TnValueTypes.registerBasicValueType(Byte.class, BYTE);
        TnValueTypes.registerBasicValueType(Short.TYPE, SHORT);
        TnValueTypes.registerBasicValueType(Short.class, SHORT);
        TnValueTypes.registerBasicValueType(Integer.TYPE, INTEGER);
        TnValueTypes.registerBasicValueType(Integer.class, INTEGER);
        TnValueTypes.registerBasicValueType(Long.TYPE, LONG);
        TnValueTypes.registerBasicValueType(Long.class, LONG);
        TnValueTypes.registerBasicValueType(Float.TYPE, FLOAT);
        TnValueTypes.registerBasicValueType(Float.class, FLOAT);
        TnValueTypes.registerBasicValueType(Double.TYPE, DOUBLE);
        TnValueTypes.registerBasicValueType(Double.class, DOUBLE);
        TnValueTypes.registerBasicValueType(BigInteger.class, BIGINTEGER);
        TnValueTypes.registerBasicValueType(BigDecimal.class, BIGDECIMAL);
        TnValueTypes.registerBasicValueType(Date.class, SQLDATE);
        TnValueTypes.registerBasicValueType(Time.class, TIME);
        TnValueTypes.registerBasicValueType(java.util.Date.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(Timestamp.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(Calendar.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(BYTE_ARRAY_CLASS, BINARY);
        TnValueTypes.registerBasicValueType(InputStream.class, BINARY_STREAM);
        TnValueTypes.registerBasicValueType(Boolean.TYPE, BOOLEAN);
        TnValueTypes.registerBasicValueType(Boolean.class, BOOLEAN);
        TnValueTypes.registerBasicValueType(UUID.class, UUID);
        TnValueTypes.registerBasicValueType(Classification.class, CLASSIFICATION);
        try {
            isEnumMethod = Class.class.getMethod("isEnum", null);
        }
        catch (Throwable ignore) {
            isEnumMethod = null;
            enumStringValueTypeConstructor = null;
            enumOrdinalValueTypeConstructor = null;
        }
    }

    private static class NullType
    implements ValueType {
        private NullType() {
        }

        public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
            throw new SQLException("not supported");
        }

        public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
            throw new SQLException("not supported");
        }

        public Object getValue(CallableStatement cs, int index) throws SQLException {
            throw new SQLException("not supported");
        }

        public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
            throw new SQLException("not supported");
        }

        public Object getValue(ResultSet resultSet, int index) throws SQLException {
            throw new SQLException("not supported");
        }

        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            throw new SQLException("not supported");
        }

        public void registerOutParameter(CallableStatement cs, int index) throws SQLException {
            throw new SQLException("not supported");
        }

        public void registerOutParameter(CallableStatement cs, String parameterName) throws SQLException {
            throw new SQLException("not supported");
        }

        public String toText(Object value) {
            throw new UnsupportedOperationException("toText");
        }

        public int getSqlType() {
            return 0;
        }
    }
}

