/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.mobylet.charset.codemap.MobyletSjisCodeMap;

public abstract class MobyletDecoder
extends CharsetDecoder {
    protected MobyletDecoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
    }

    protected char decodeStandardDouble(int b1, int b2) {
        return MobyletSjisCodeMap.toChar((b1 << 8) + b2);
    }

    protected abstract char decodeEmojiDouble(int var1, int var2);

    protected abstract short getMinEmojiFirstCode();

    protected abstract short getMaxEmojiFirstCode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        int pos = in.position();
        try {
            while (in.hasRemaining()) {
                int b2;
                if (out.remaining() == 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                int b1 = in.get() & 0xFF;
                if (b1 <= 128) {
                    out.put((char)b1);
                    ++pos;
                    continue;
                }
                if (160 <= b1 && b1 <= 223) {
                    int kana = (b1 | 0xFF00) - 64;
                    if (b1 == 160) {
                        kana = 63728;
                    }
                    out.put((char)kana);
                    ++pos;
                    continue;
                }
                if (this.getMinEmojiFirstCode() <= b1 && b1 <= this.getMaxEmojiFirstCode()) {
                    if (!in.hasRemaining()) continue;
                    b2 = in.get() & 0xFF;
                    char c = this.decodeEmojiDouble(b1, b2);
                    if (c != '\ufffd') {
                        out.put(c);
                        pos += 2;
                        continue;
                    }
                    out.put(this.decodeStandardDouble(b1, b2));
                    ++pos;
                    in.position(in.position() - 1);
                    continue;
                }
                if (!in.hasRemaining()) continue;
                b2 = in.get() & 0xFF;
                out.put(this.decodeStandardDouble(b1, b2));
                pos += 2;
            }
        }
        finally {
            in.position(pos);
        }
        return CoderResult.UNDERFLOW;
    }
}

