/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.handler.impl.execute;

import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import org.seasar.chronos.core.delegate.AsyncResult;
import org.seasar.chronos.core.delegate.MethodInvoker;
import org.seasar.chronos.core.task.Transition;
import org.seasar.chronos.core.task.handler.TaskExecuteHandler;
import org.seasar.chronos.core.task.handler.impl.AbstractTaskExecuteHandler;
import org.seasar.chronos.core.task.impl.TaskMethodManager;
import org.seasar.chronos.core.task.impl.TaskMethodMetaData;
import org.seasar.framework.log.Logger;

public class TaskGroupMethodExecuteHandlerImpl
extends AbstractTaskExecuteHandler {
    private static final long serialVersionUID = 7197512242818142008L;
    private static Logger log = Logger.getLogger(TaskGroupMethodExecuteHandlerImpl.class);
    private TaskExecuteHandler taskMethodExecuteHandler;

    public void setTaskMethodExecuteHandler(TaskExecuteHandler taskMethodExecuteHandler) {
        this.taskMethodExecuteHandler = taskMethodExecuteHandler;
    }

    public void setMethodGroupMap(TaskMethodManager taskMethodManager) {
        super.setMethodGroupMap(taskMethodManager);
        this.taskMethodExecuteHandler.setMethodGroupMap(taskMethodManager);
    }

    public void setMethodInvoker(MethodInvoker methodInvoker) {
        super.setMethodInvoker(methodInvoker);
        this.taskMethodExecuteHandler.setMethodInvoker(methodInvoker);
    }

    private String getFirstFunction(String taskName) {
        List<Method> ret = this.taskMethodManager.getMethodList(taskName);
        return ret.listIterator().next().getName();
    }

    public Transition handleRequest(String startTaskName) throws InterruptedException {
        String firstChar = startTaskName.substring(0, 1);
        String afterString = startTaskName.substring(1);
        String groupName = firstChar.toUpperCase() + afterString;
        Transition ts = this.getTerminateTransition();
        if (ts != null) {
            return ts;
        }
        String nextTask = this.invokeStartJobGroupMethod(groupName);
        if (nextTask == null) {
            String firstFunction = this.getFirstFunction(startTaskName);
            nextTask = this.toTaskName(firstFunction);
        } else if (this.taskMethodManager.existGroup(nextTask)) {
            log.debug((Object)"startGroup\u7e3a\uff6e\u8c3a\uff61\u7e3a\uff6f\u7e5d\uff61\u7e67\uff7d\u7e5d\ufffd\u7e5d\u5ce8\uff52\u8b16\ufffd\u87b3\u58f9\uff20\u7e3a\uff66\u7e3a\u4e0a\u25a1\u7e3a\u8f14\uff1e");
            return new Transition(true, nextTask);
        }
        ts = this.getTerminateTransition();
        if (ts != null) {
            return ts;
        }
        Transition transition = this.taskMethodExecuteHandler.handleRequest(nextTask);
        ts = this.getTerminateTransition();
        if (ts != null) {
            return ts;
        }
        nextTask = this.invokeEndJobGroupMethod(groupName);
        if (nextTask == null) {
            List<Method> allMethod = this.taskMethodManager.getAllMethodList();
            if (transition.getLastTaskName() != null) {
                TaskMethodMetaData md;
                String nextGroupName;
                String lastTaskName = this.toMethodName(transition.getLastTaskName());
                ListIterator<Method> li = allMethod.listIterator();
                Method method = null;
                while (li.hasNext()) {
                    method = li.next();
                    if (!method.getName().equals(lastTaskName)) continue;
                    if (!li.hasNext()) break;
                    method = li.next();
                    nextTask = this.toTaskName(method.getName());
                    break;
                }
                if (nextTask != null && (nextGroupName = (md = new TaskMethodMetaData(method)).getGroupName()) != null) {
                    nextTask = nextGroupName;
                }
            }
        }
        if (nextTask == null) {
            return new Transition(true);
        }
        if (this.taskMethodManager.existGroup(nextTask)) {
            return this.handleRequest(nextTask);
        }
        return new Transition(false, nextTask);
    }

    private String invokeEndJobGroupMethod(String groupName) throws InterruptedException {
        String methodName = "end" + groupName;
        return this.invokeGroupMethod(methodName);
    }

    private String invokeStartJobGroupMethod(String groupName) throws InterruptedException {
        String methodName = "start" + groupName;
        return this.invokeGroupMethod(methodName);
    }

    private String invokeGroupMethod(String methodName) throws InterruptedException {
        MethodInvoker mi = this.getMethodInvoker();
        if (mi.hasMethod(methodName)) {
            AsyncResult ar = mi.beginInvoke(methodName);
            mi.endInvoke(ar);
            TaskMethodMetaData md = new TaskMethodMetaData(mi.getMethod(methodName));
            return md.getNextTask();
        }
        return null;
    }
}

