/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.beans;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.beans.Field;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentObjectBinder {
    private final Map<Class, List<DocField>> infocache = new ConcurrentHashMap<Class, List<DocField>>();

    public <T> List<T> getBeans(Class<T> clazz, SolrDocumentList solrDocList) {
        List<DocField> fields = this.getDocFields(clazz);
        ArrayList result = new ArrayList(solrDocList.size());
        for (int j = 0; j < solrDocList.size(); ++j) {
            SolrDocument sdoc = (SolrDocument)solrDocList.get(j);
            Object obj = null;
            try {
                obj = clazz.newInstance();
                result.add(obj);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate object of " + clazz, e);
            }
            for (int i = 0; i < fields.size(); ++i) {
                DocField docField = fields.get(i);
                docField.inject(obj, sdoc);
            }
        }
        return result;
    }

    public SolrInputDocument toSolrInputDocument(Object obj) {
        List<DocField> fields = this.getDocFields(obj.getClass());
        if (fields.isEmpty()) {
            throw new RuntimeException("class: " + obj.getClass() + " does not define any fields.");
        }
        SolrInputDocument doc = new SolrInputDocument();
        for (DocField field : fields) {
            doc.setField(field.name, field.get(obj), 1.0f);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocField> getDocFields(Class clazz) {
        List<DocField> fields = this.infocache.get(clazz);
        if (fields == null) {
            Map<Class, List<DocField>> map = this.infocache;
            synchronized (map) {
                fields = this.collectInfo(clazz);
                this.infocache.put(clazz, fields);
            }
        }
        return fields;
    }

    private List<DocField> collectInfo(Class clazz) {
        ArrayList<DocField> fields = new ArrayList<DocField>();
        ArrayList<AccessibleObject> members = new ArrayList<AccessibleObject>();
        for (Class superClazz = clazz; superClazz != null && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            members.addAll(Arrays.asList(superClazz.getDeclaredFields()));
            members.addAll(Arrays.asList(superClazz.getDeclaredMethods()));
        }
        for (AccessibleObject member : members) {
            if (!member.isAnnotationPresent(Field.class)) continue;
            member.setAccessible(true);
            fields.add(new DocField(member));
        }
        return fields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocField {
        private String name;
        private java.lang.reflect.Field field;
        private Method setter;
        private Method getter;
        private Class type;
        private boolean isArray;
        private boolean isList;

        public DocField(AccessibleObject member) {
            block7: {
                String gname;
                this.isArray = false;
                this.isList = false;
                if (member instanceof java.lang.reflect.Field) {
                    this.field = (java.lang.reflect.Field)member;
                } else {
                    this.setter = (Method)member;
                }
                Field annotation = member.getAnnotation(Field.class);
                this.storeName(annotation);
                this.storeType();
                if (this.setter != null && (gname = this.setter.getName()).startsWith("set")) {
                    gname = "get" + gname.substring(3);
                    try {
                        this.getter = this.setter.getDeclaringClass().getMethod(gname, null);
                    }
                    catch (Exception ex) {
                        if (this.type != Boolean.class) break block7;
                        gname = "is" + this.setter.getName().substring(3);
                        try {
                            this.getter = this.setter.getDeclaringClass().getMethod(gname, null);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private void storeName(Field annotation) {
            String setterName;
            this.name = annotation.value().equals("#default") ? (this.field != null ? this.field.getName() : ((setterName = this.setter.getName()).startsWith("set") && setterName.length() > 3 ? setterName.substring(3, 4).toLowerCase() + setterName.substring(4) : this.setter.getName())) : annotation.value();
        }

        private void storeType() {
            if (this.field != null) {
                this.type = this.field.getType();
            } else {
                Class<?>[] params = this.setter.getParameterTypes();
                if (params.length != 1) {
                    throw new RuntimeException("Invalid setter method. Must have one and only one parameter");
                }
                this.type = params[0];
            }
            if (this.type == Collection.class || this.type == List.class || this.type == ArrayList.class) {
                this.type = Object.class;
                this.isList = true;
            } else if (this.type.isArray()) {
                this.isArray = true;
                this.type = this.type.getComponentType();
            }
        }

        public <T> void inject(T obj, SolrDocument sdoc) {
            Object val = sdoc.getFieldValue(this.name);
            if (val == null) {
                return;
            }
            if (this.isArray) {
                if (val instanceof List) {
                    List collection = (List)val;
                    this.set(obj, collection.toArray((Object[])Array.newInstance(this.type, collection.size())));
                } else {
                    Object[] arr = (Object[])Array.newInstance(this.type, 1);
                    arr[0] = val;
                    this.set(obj, arr);
                }
            } else if (this.isList) {
                if (val instanceof List) {
                    this.set(obj, val);
                } else {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(val);
                    this.set(obj, l);
                }
            } else if (val instanceof List) {
                List l = (List)val;
                if (l.size() > 0) {
                    this.set(obj, l.get(0));
                }
            } else {
                this.set(obj, val);
            }
        }

        private void set(Object obj, Object v) {
            try {
                if (this.field != null) {
                    this.field.set(obj, v);
                } else if (this.setter != null) {
                    this.setter.invoke(obj, v);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while setting value : " + v + " on " + (this.field != null ? this.field : this.setter), e);
            }
        }

        public Object get(Object obj) {
            if (this.field != null) {
                try {
                    return this.field.get(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while getting value: " + this.field, e);
                }
            }
            if (this.getter == null) {
                throw new RuntimeException("Missing getter for field: " + this.name + " -- You can only call the 'get' for fields that have a field of 'get' method");
            }
            try {
                return this.getter.invoke(obj, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while getting value: " + this.getter, e);
            }
        }
    }
}

