/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;

public class HighlightComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "highlight";

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrHighlighter highlighter = rb.req.getCore().getHighlighter();
        rb.doHighlights = highlighter.isHighlightingEnabled(rb.req.getParams());
    }

    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        if (rb.doHighlights) {
            NamedList<Object> sumData;
            SolrHighlighter highlighter = req.getCore().getHighlighter();
            SolrParams params = req.getParams();
            String[] defaultHighlightFields = rb.getQparser() != null ? rb.getQparser().getDefaultHighlightFields() : params.getParams("df");
            Query highlightQuery = rb.getHighlightQuery();
            if (highlightQuery == null) {
                if (rb.getQparser() != null) {
                    try {
                        highlightQuery = rb.getQparser().getHighlightQuery();
                        rb.setHighlightQuery(highlightQuery);
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                } else {
                    highlightQuery = rb.getQuery();
                    rb.setHighlightQuery(highlightQuery);
                }
            }
            if (highlightQuery != null && (sumData = highlighter.doHighlighting(rb.getResults().docList, highlightQuery.rewrite(req.getSearcher().getReader()), req, defaultHighlightFields)) != null) {
                rb.rsp.add("highlighting", sumData);
            }
        }
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doHighlights) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            sreq.purpose |= 0x80;
            sreq.params.set("hl", new String[]{"true"});
        } else {
            sreq.params.set("hl", new String[]{"false"});
        }
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
    }

    public void finishStage(ResponseBuilder rb) {
        if (rb.doHighlights && rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            SimpleOrderedMap hlResult = new SimpleOrderedMap();
            Object[] arr = new Object[rb.resultIds.size() * 2];
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x80) == 0) continue;
                for (ShardResponse srsp : sreq.responses) {
                    NamedList hl = (NamedList)srsp.getSolrResponse().getResponse().get("highlighting");
                    for (int i = 0; i < hl.size(); ++i) {
                        String id = hl.getName(i);
                        ShardDoc sdoc = rb.resultIds.get(id);
                        int idx = sdoc.positionInResponse;
                        arr[idx << 1] = id;
                        arr[(idx << 1) + 1] = hl.getVal(i);
                    }
                }
            }
            rb.rsp.add("highlighting", HighlightComponent.removeNulls((NamedList)new SimpleOrderedMap(Arrays.asList(arr))));
        }
    }

    static NamedList removeNulls(NamedList nl) {
        for (int i = 0; i < nl.size(); ++i) {
            if (nl.getName(i) != null) continue;
            SimpleOrderedMap newList = nl instanceof SimpleOrderedMap ? new SimpleOrderedMap() : new NamedList();
            for (int j = 0; j < nl.size(); ++j) {
                String n = nl.getName(j);
                if (n == null) continue;
                newList.add(n, nl.getVal(j));
            }
            return newList;
        }
        return nl;
    }

    public String getDescription() {
        return "Highlighting";
    }

    public String getVersion() {
        return "$Revision: 679477 $";
    }

    public String getSourceId() {
        return "$Id: HighlightComponent.java 679477 2008-07-24 18:07:01Z ryan $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/component/HighlightComponent.java $";
    }

    public URL[] getDocs() {
        return null;
    }
}

