/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.NamedListCodec;
import org.apache.solr.request.BinaryQueryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;

public class BinaryResponseWriter
implements BinaryQueryResponseWriter {
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        Resolver resolver = new Resolver(req, response.getReturnFields());
        NamedListCodec codec = new NamedListCodec((NamedListCodec.ObjectResolver)resolver);
        codec.marshal(response.getValues(), out);
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    public void init(NamedList args) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Resolver
    implements NamedListCodec.ObjectResolver {
        private final IndexSchema schema;
        private final SolrIndexSearcher searcher;
        private final Set<String> returnFields;
        private final boolean includeScore;
        boolean useFieldObjects = true;

        public Resolver(SolrQueryRequest req, Set<String> returnFields) {
            this.schema = req.getSchema();
            this.searcher = req.getSearcher();
            boolean bl = this.includeScore = returnFields != null && returnFields.contains("score");
            if (returnFields != null && (returnFields.size() == 0 || returnFields.size() == 1 && this.includeScore || returnFields.contains("*"))) {
                returnFields = null;
            }
            this.returnFields = returnFields;
        }

        public Object resolve(Object o, NamedListCodec codec) throws IOException {
            if (o instanceof DocList) {
                this.writeDocList((DocList)o, codec);
                return null;
            }
            if (o instanceof SolrDocument) {
                SolrDocument solrDocument = (SolrDocument)o;
                codec.writeSolrDocument(solrDocument, this.returnFields);
                return null;
            }
            if (o instanceof Document) {
                return this.getDoc((Document)o);
            }
            return o;
        }

        public void writeDocList(DocList ids, NamedListCodec codec) throws IOException {
            codec.writeTag((byte)12);
            ArrayList<Number> l = new ArrayList<Number>(3);
            l.add(Long.valueOf(ids.matches()));
            l.add(Long.valueOf(ids.offset()));
            Float maxScore = null;
            if (this.includeScore && ids.hasScores()) {
                maxScore = Float.valueOf(ids.maxScore());
            }
            l.add(maxScore);
            codec.writeArray(l);
            int sz = ids.size();
            codec.writeTag((byte)-128, sz);
            DocIterator iterator = ids.iterator();
            for (int i = 0; i < sz; ++i) {
                int id = iterator.nextDoc();
                Document doc = this.searcher.doc(id, this.returnFields);
                SolrDocument sdoc = this.getDoc(doc);
                if (this.includeScore && ids.hasScores()) {
                    sdoc.addField("score", (Object)Float.valueOf(iterator.score()));
                }
                codec.writeSolrDocument(sdoc);
            }
        }

        public SolrDocument getDoc(Document doc) {
            SolrDocument solrDoc = new SolrDocument();
            for (Fieldable f : doc.getFields()) {
                String fieldName = f.name();
                if (this.returnFields != null && !this.returnFields.contains(fieldName)) continue;
                FieldType ft = this.schema.getFieldTypeNoEx(fieldName);
                Object val = ft == null ? (f.isBinary() ? f.binaryValue() : (Object)f.stringValue()) : (Object)(this.useFieldObjects ? ft.toObject(f) : ft.toExternal(f));
                solrDoc.addField(fieldName, val);
            }
            return solrDoc;
        }
    }
}

