/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableFloatFieldSource;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableFloatField
extends FieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        return new SortableFloatFieldSource(field.name);
    }

    @Override
    public String toInternal(String val) {
        return NumberUtils.float2sortableStr(val);
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Float toObject(Fieldable f) {
        return Float.valueOf(NumberUtils.SortableStr2float(f.stringValue()));
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2floatStr(indexedForm);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        xmlWriter.writeFloat(name, NumberUtils.SortableStr2float(sval));
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        writer.writeFloat(name, NumberUtils.SortableStr2float(sval));
    }
}

