/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class ConstValueSource
extends ValueSource {
    final float constant;

    public ConstValueSource(float constant) {
        this.constant = constant;
    }

    public String description() {
        return "const(" + this.constant + ")";
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        return new DocValues(){

            public float floatVal(int doc) {
                return ConstValueSource.this.constant;
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return ConstValueSource.this.description();
            }
        };
    }

    public int hashCode() {
        return Float.floatToIntBits(this.constant) * 31;
    }

    public boolean equals(Object o) {
        if (ConstValueSource.class != o.getClass()) {
            return false;
        }
        ConstValueSource other = (ConstValueSource)o;
        return this.constant == other.constant;
    }
}

