/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similar;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class SimilarityQueries {
    private SimilarityQueries() {
    }

    public static Query formSimilarQuery(String body, Analyzer a, String field, Set stop) throws IOException {
        TokenStream ts = a.tokenStream(field, (Reader)new StringReader(body));
        BooleanQuery tmp = new BooleanQuery();
        HashSet<String> already = new HashSet<String>();
        Token reusableToken = new Token();
        Token nextToken = ts.next(reusableToken);
        while (nextToken != null) {
            String word = nextToken.term();
            if ((stop == null || !stop.contains(word)) && already.add(word)) {
                TermQuery tq = new TermQuery(new Term(field, word));
                try {
                    tmp.add((Query)tq, BooleanClause.Occur.SHOULD);
                }
                catch (BooleanQuery.TooManyClauses too) {
                    break;
                }
            }
            nextToken = ts.next(reusableToken);
        }
        return tmp;
    }
}

