/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Value
implements Function {
    private static final int MIN_DISTANCE_BETWEEN_THOUSANDS_SEPARATOR = 4;
    private static final Double ZERO = new Double(0.0);

    public ValueEval evaluate(ValueEval[] args, int srcCellRow, short srcCellCol) {
        ValueEval veText;
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            veText = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        String strText = OperandResolver.coerceValueToString(veText);
        Double result = Value.convertTextToNumber(strText);
        if (result == null) {
            return ErrorEval.VALUE_INVALID;
        }
        return new NumberEval(result);
    }

    private static Double convertTextToNumber(String strText) {
        double d;
        char ch;
        int i;
        boolean foundCurrency = false;
        boolean foundUnaryPlus = false;
        boolean foundUnaryMinus = false;
        int len = strText.length();
        block14: for (i = 0; i < len && !Character.isDigit(ch = strText.charAt(i)) && ch != '.'; ++i) {
            switch (ch) {
                case ' ': {
                    continue block14;
                }
                case '$': {
                    if (foundCurrency) {
                        return null;
                    }
                    foundCurrency = true;
                    continue block14;
                }
                case '+': {
                    if (foundUnaryMinus || foundUnaryPlus) {
                        return null;
                    }
                    foundUnaryPlus = true;
                    continue block14;
                }
                case '-': {
                    if (foundUnaryMinus || foundUnaryPlus) {
                        return null;
                    }
                    foundUnaryMinus = true;
                    continue block14;
                }
                default: {
                    return null;
                }
            }
        }
        if (i >= len) {
            if (foundCurrency || foundUnaryMinus || foundUnaryPlus) {
                return null;
            }
            return ZERO;
        }
        boolean foundDecimalPoint = false;
        int lastThousandsSeparatorIndex = Short.MIN_VALUE;
        StringBuffer sb = new StringBuffer(len);
        while (i < len) {
            char ch2 = strText.charAt(i);
            if (Character.isDigit(ch2)) {
                sb.append(ch2);
            } else {
                switch (ch2) {
                    case ' ': {
                        String remainingText = strText.substring(i);
                        if (remainingText.trim().length() <= 0) break;
                        return null;
                    }
                    case '.': {
                        if (foundDecimalPoint) {
                            return null;
                        }
                        if (i - lastThousandsSeparatorIndex < 4) {
                            return null;
                        }
                        foundDecimalPoint = true;
                        sb.append('.');
                        break;
                    }
                    case ',': {
                        if (foundDecimalPoint) {
                            return null;
                        }
                        int distanceBetweenThousandsSeparators = i - lastThousandsSeparatorIndex;
                        if (distanceBetweenThousandsSeparators < 4) {
                            return null;
                        }
                        lastThousandsSeparatorIndex = i;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (i - lastThousandsSeparatorIndex < 4) {
                            return null;
                        }
                        sb.append(strText.substring(i));
                        i = len;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            ++i;
        }
        if (!foundDecimalPoint && i - lastThousandsSeparatorIndex < 4) {
            return null;
        }
        try {
            d = Double.parseDouble(sb.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Double(foundUnaryMinus ? -d : d);
    }
}

