/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.solr.search.IdGenerator;

abstract class WildcardGenerator
implements IdGenerator {
    protected final Term wildcard;

    WildcardGenerator(Term wildcard) {
        this.wildcard = wildcard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndexReader reader) throws IOException {
        WildcardTermEnum enumerator = new WildcardTermEnum(reader, this.wildcard);
        TermDocs termDocs = reader.termDocs();
        try {
            do {
                Term term;
                if ((term = enumerator.term()) == null) {
                    break;
                }
                termDocs.seek(term);
                while (termDocs.next()) {
                    this.handleDoc(termDocs.doc());
                }
            } while (enumerator.next());
        }
        finally {
            termDocs.close();
            enumerator.close();
        }
    }
}

