/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.ConstructorAssembler;
import org.seasar.framework.container.MethodAssembler;
import org.seasar.framework.container.PropertyAssembler;
import org.seasar.framework.container.assembler.AssemblerFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractComponentDeployer
implements ComponentDeployer {
    private ComponentDef componentDef;
    private ConstructorAssembler constructorAssembler;
    private PropertyAssembler propertyAssembler;
    private MethodAssembler initMethodAssembler;
    private MethodAssembler destroyMethodAssembler;

    public AbstractComponentDeployer(ComponentDef componentDef) {
        this.componentDef = componentDef;
        this.setupAssembler();
    }

    protected final ComponentDef getComponentDef() {
        return this.componentDef;
    }

    protected final ConstructorAssembler getConstructorAssembler() {
        return this.constructorAssembler;
    }

    protected final PropertyAssembler getPropertyAssembler() {
        return this.propertyAssembler;
    }

    protected final MethodAssembler getInitMethodAssembler() {
        return this.initMethodAssembler;
    }

    protected final MethodAssembler getDestroyMethodAssembler() {
        return this.destroyMethodAssembler;
    }

    protected void setupAssembler() {
        AutoBindingDef autoBindingDef = this.componentDef.getAutoBindingDef();
        this.constructorAssembler = autoBindingDef.createConstructorAssembler(this.componentDef);
        this.propertyAssembler = autoBindingDef.createPropertyAssembler(this.componentDef);
        this.initMethodAssembler = AssemblerFactory.createInitMethodAssembler(this.componentDef);
        this.destroyMethodAssembler = AssemblerFactory.createDestroyMethodAssembler(this.componentDef);
    }

    protected String getComponentName() {
        String componentName = this.componentDef.getComponentName();
        if (componentName == null) {
            componentName = ClassUtil.getShortClassName(this.componentDef.getComponentClass());
            componentName = StringUtil.decapitalize(componentName);
        }
        return componentName;
    }
}

