/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.portlet;

import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.external.portlet.PortletApplicationMap;
import org.seasar.framework.container.external.portlet.PortletInitParameterMap;
import org.seasar.framework.container.external.portlet.PortletRequestHeaderMap;
import org.seasar.framework.container.external.portlet.PortletRequestHeaderValuesMap;
import org.seasar.framework.container.external.portlet.PortletRequestMap;
import org.seasar.framework.container.external.portlet.PortletRequestParameterMap;
import org.seasar.framework.container.external.portlet.PortletRequestParameterValuesMap;
import org.seasar.framework.container.external.portlet.PortletSessionMap;
import org.seasar.framework.exception.EmptyRuntimeException;

public class PortletExternalContext
implements ExternalContext {
    private ThreadLocal requests = new ThreadLocal();
    private ThreadLocal responses = new ThreadLocal();
    private ThreadLocal configs = new ThreadLocal();
    private PortletContext application;

    public Object getRequest() {
        return this.getPortletRequest();
    }

    protected PortletRequest getPortletRequest() {
        return (PortletRequest)this.requests.get();
    }

    public void setRequest(Object request) {
        this.requests.set(request);
    }

    public Object getResponse() {
        return this.responses.get();
    }

    public void setResponse(Object response) {
        this.responses.set(response);
    }

    public Object getConfig() {
        return this.configs.get();
    }

    public void setConfig(Object config) {
        this.configs.set(config);
    }

    public Object getSession() {
        PortletRequest request = this.getPortletRequest();
        if (request == null) {
            throw new EmptyRuntimeException("request");
        }
        return request.getPortletSession();
    }

    public Object getApplication() {
        return this.application;
    }

    public void setApplication(Object application) {
        if (!(application instanceof PortletContext)) {
            throw new IllegalArgumentException("application:" + application);
        }
        this.application = (PortletContext)application;
    }

    public Map getApplicationMap() {
        return new PortletApplicationMap(this.application);
    }

    public Map getInitParameterMap() {
        return new PortletInitParameterMap(this.application);
    }

    public Map getRequestCookieMap() {
        return Collections.EMPTY_MAP;
    }

    public Map getRequestHeaderMap() {
        return new PortletRequestHeaderMap(this.getPortletRequest());
    }

    public Map getRequestHeaderValuesMap() {
        return new PortletRequestHeaderValuesMap(this.getPortletRequest());
    }

    public Map getRequestMap() {
        return new PortletRequestMap(this.getPortletRequest());
    }

    public Map getRequestParameterMap() {
        return new PortletRequestParameterMap(this.getPortletRequest());
    }

    public Map getRequestParameterValuesMap() {
        return new PortletRequestParameterValuesMap(this.getPortletRequest());
    }

    public Map getSessionMap() {
        return new PortletSessionMap(this.getPortletRequest());
    }
}

