/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.util;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.seasar.framework.util.LruHashMap;
import org.seasar.framework.util.StatementUtil;

public class StatementCache
extends LruHashMap {
    private static final long serialVersionUID = 1L;

    public StatementCache(int limitSize) {
        super(limitSize);
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        if (super.removeEldestEntry(entry)) {
            Statement stmt = (Statement)entry.getValue();
            StatementUtil.close((Statement)stmt);
            return true;
        }
        return false;
    }

    public void destroy() throws SQLException {
        SQLException e = null;
        for (Statement stmt : this.values()) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                e = ex;
            }
        }
        this.clear();
        if (e != null) {
            throw e;
        }
    }
}

