/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.util.LikeUtil;
import org.seasar.extension.jdbc.where.SingleValueOperator;
import org.seasar.framework.util.StringUtil;

public class LikeOperator
extends SingleValueOperator {
    protected String escapeChar;
    protected boolean needEscape;

    public LikeOperator(ConditionType conditionType, CharSequence propertyName, Object value) {
        super(conditionType, propertyName, value);
        switch (conditionType) {
            case STARTS: 
            case NOT_STARTS: 
            case ENDS: 
            case NOT_ENDS: 
            case CONTAINS: 
            case NOT_CONTAINS: {
                this.needEscape = true;
            }
        }
    }

    public LikeOperator(ConditionType conditionType, CharSequence propertyName, Object value, String escapeChar) {
        super(conditionType, propertyName, value);
        this.escapeChar = escapeChar;
    }

    public LikeOperator(ConditionType conditionType, CharSequence propertyName, Object value, boolean needEscape) {
        super(conditionType, propertyName, value);
        this.needEscape = needEscape;
    }

    protected Object normalize(Object value) {
        Object param = super.normalize(value);
        if (param == null) {
            return null;
        }
        if (!StringUtil.isEmpty((String)this.escapeChar)) {
            return new Object[]{param, this.escapeChar};
        }
        if (!this.needEscape) {
            return param;
        }
        String normalizedValue = (String)param;
        if (!LikeUtil.containsWildcard(normalizedValue)) {
            return normalizedValue;
        }
        switch (this.conditionType) {
            case STARTS: {
                this.conditionType = ConditionType.STARTS_ESCAPE;
                break;
            }
            case NOT_STARTS: {
                this.conditionType = ConditionType.NOT_STARTS_ESCAPE;
                break;
            }
            case ENDS: {
                this.conditionType = ConditionType.ENDS_ESCAPE;
                break;
            }
            case NOT_ENDS: {
                this.conditionType = ConditionType.NOT_ENDS_ESCAPE;
                break;
            }
            case CONTAINS: {
                this.conditionType = ConditionType.CONTAINS_ESCAPE;
                break;
            }
            case NOT_CONTAINS: {
                this.conditionType = ConditionType.NOT_CONTAINS_ESCAPE;
            }
        }
        return LikeUtil.escapeWildcard((String)String.class.cast(normalizedValue));
    }
}

