/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.util;

import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.beans.ConverterRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.converter.DateConverter;
import org.seasar.framework.beans.converter.NumberConverter;
import org.seasar.framework.beans.converter.SqlDateConverter;
import org.seasar.framework.beans.converter.TimeConverter;
import org.seasar.framework.beans.converter.TimestampConverter;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.TimeConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopy<S extends AbstractCopy<S>> {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final Converter DEFAULT_DATE_CONVERTER = new DateConverter(DateConversionUtil.getY4Pattern((Locale)Locale.getDefault()));
    protected static final Converter DEFAULT_TIMESTAMP_CONVERTER = new DateConverter(TimestampConversionUtil.getPattern((Locale)Locale.getDefault()));
    protected static final Converter DEFAULT_TIME_CONVERTER = new DateConverter(TimeConversionUtil.getPattern((Locale)Locale.getDefault()));
    protected String[] includePropertyNames = EMPTY_STRING_ARRAY;
    protected String[] excludePropertyNames = EMPTY_STRING_ARRAY;
    protected boolean excludesNull = false;
    protected boolean excludesWhitespace = false;
    protected String prefix;
    protected char beanDelimiter = (char)36;
    protected char mapDelimiter = (char)46;
    protected Map<String, Converter> converterMap = new HashMap<String, Converter>();
    protected List<Converter> converters = new ArrayList<Converter>();

    protected String[] toStringArray(CharSequence[] charSequenceArray) {
        int length = charSequenceArray.length;
        String[] stringArray = new String[length];
        for (int index = 0; index < length; ++index) {
            stringArray[index] = ((Object)charSequenceArray[index]).toString();
        }
        return stringArray;
    }

    public S includes(CharSequence ... propertyNames) {
        this.includePropertyNames = this.toStringArray(propertyNames);
        return (S)this;
    }

    public S excludes(CharSequence ... propertyNames) {
        this.excludePropertyNames = this.toStringArray(propertyNames);
        return (S)this;
    }

    public S excludesNull() {
        this.excludesNull = true;
        return (S)this;
    }

    public S excludesWhitespace() {
        this.excludesWhitespace = true;
        return (S)this;
    }

    public S prefix(CharSequence prefix) {
        this.prefix = ((Object)prefix).toString();
        return (S)this;
    }

    public S beanDelimiter(char beanDelimiter) {
        this.beanDelimiter = beanDelimiter;
        return (S)this;
    }

    public S mapDelimiter(char mapDelimiter) {
        this.mapDelimiter = mapDelimiter;
        return (S)this;
    }

    public S converter(Converter converter, CharSequence ... propertyNames) {
        if (propertyNames.length == 0) {
            this.converters.add(converter);
        } else {
            for (CharSequence name : propertyNames) {
                this.converterMap.put(((Object)name).toString(), converter);
            }
        }
        return (S)this;
    }

    public S dateConverter(String pattern, CharSequence ... propertyNames) {
        return this.converter((Converter)new DateConverter(pattern), propertyNames);
    }

    public S sqlDateConverter(String pattern, CharSequence ... propertyNames) {
        return this.converter((Converter)new SqlDateConverter(pattern), propertyNames);
    }

    public S timeConverter(String pattern, CharSequence ... propertyNames) {
        return this.converter((Converter)new TimeConverter(pattern), propertyNames);
    }

    public S timestampConverter(String pattern, CharSequence ... propertyNames) {
        return this.converter((Converter)new TimestampConverter(pattern), propertyNames);
    }

    public S numberConverter(String pattern, CharSequence ... propertyNames) {
        return this.converter((Converter)new NumberConverter(pattern), propertyNames);
    }

    protected boolean isTargetProperty(String name) {
        if (this.prefix != null && !name.startsWith(this.prefix)) {
            return false;
        }
        if (this.includePropertyNames.length > 0) {
            for (String s : this.includePropertyNames) {
                if (!s.equals(name)) continue;
                for (String s2 : this.excludePropertyNames) {
                    if (!s2.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludePropertyNames.length > 0) {
            for (String s : this.excludePropertyNames) {
                if (!s.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected void copyBeanToBean(Object src, Object dest) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        int size = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !this.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = this.trimPrefix(srcPropertyName)) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || (value = srcPropertyDesc.getValue(src)) instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            value = this.convertValue(value, destPropertyName, destPropertyDesc.getPropertyType());
            destPropertyDesc.setValue(dest, value);
        }
    }

    protected void copyBeanToMap(Object src, Map dest) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        int size = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Object value;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !this.isTargetProperty(srcPropertyName) || (value = srcPropertyDesc.getValue(src)) instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName.replace(this.beanDelimiter, this.mapDelimiter));
            value = this.convertValue(value, destPropertyName, null);
            dest.put(destPropertyName, value);
        }
    }

    protected void copyMapToBean(Map<String, Object> src, Object dest) {
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (String srcPropertyName : src.keySet()) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            if (!this.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = this.trimPrefix(srcPropertyName.replace(this.mapDelimiter, this.beanDelimiter))) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || (value = src.get(srcPropertyName)) instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            value = this.convertValue(value, destPropertyName, destPropertyDesc.getPropertyType());
            destPropertyDesc.setValue(dest, value);
        }
    }

    protected void copyMapToMap(Map<String, Object> src, Map<String, Object> dest) {
        for (String srcPropertyName : src.keySet()) {
            if (!this.isTargetProperty(srcPropertyName)) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName);
            Object value = src.get(srcPropertyName);
            if (value instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            value = this.convertValue(value, destPropertyName, null);
            dest.put(destPropertyName, value);
        }
    }

    protected String trimPrefix(String propertyName) {
        if (this.prefix == null) {
            return propertyName;
        }
        return propertyName.substring(this.prefix.length());
    }

    protected Object convertValue(Object value, String destPropertyName, Class<?> destPropertyClass) {
        if (value == null || value.getClass() != String.class && destPropertyClass != null && destPropertyClass != String.class) {
            return value;
        }
        Converter converter = this.converterMap.get(destPropertyName);
        if (converter == null) {
            Class<?> targetClass;
            Class<?> clazz = targetClass = value.getClass() != String.class ? value.getClass() : destPropertyClass;
            if (targetClass == null) {
                return value;
            }
            for (Class<?> clazz2 = targetClass; clazz2 != Object.class && clazz2 != null && (converter = this.findConverter(clazz2)) == null; clazz2 = clazz2.getSuperclass()) {
            }
            if (converter == null && destPropertyClass != null) {
                converter = this.findDefaultConverter(targetClass);
            }
            if (converter == null) {
                return value;
            }
        }
        try {
            if (value.getClass() == String.class) {
                return converter.getAsObject((String)value);
            }
            return converter.getAsString(value);
        }
        catch (Throwable cause) {
            throw new ConverterRuntimeException(destPropertyName, value, cause);
        }
    }

    protected Converter findConverter(Class<?> clazz) {
        for (Converter c : this.converters) {
            if (!c.isTarget(clazz)) continue;
            return c;
        }
        return null;
    }

    protected Converter findDefaultConverter(Class<?> clazz) {
        if (clazz == Date.class) {
            return DEFAULT_DATE_CONVERTER;
        }
        if (clazz == Time.class) {
            return DEFAULT_TIME_CONVERTER;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return DEFAULT_TIMESTAMP_CONVERTER;
        }
        return null;
    }
}

