/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.seasar.framework.jpa.util.ChildFirstClassLoader;
import org.seasar.framework.jpa.util.TransformClassLoader;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    protected TransformClassLoader classLoader;
    protected URL persistenceUnitRootUrl;
    protected String persistenceUnitName;
    protected PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.JTA;
    protected String persistenceProviderClassName;
    protected DataSource jtaDataSource;
    protected DataSource nonJtaDataSource;
    protected List<String> mappingFileNames = CollectionsUtil.newArrayList();
    protected List<URL> jarFileUrls = CollectionsUtil.newArrayList();
    protected List<String> managedClassNames = CollectionsUtil.newArrayList();
    protected boolean excludeUnlistedClasses;
    protected Properties properties = new Properties();
    protected List<ClassTransformer> transformers = CollectionsUtil.newArrayList();

    public PersistenceUnitInfoImpl() {
    }

    public PersistenceUnitInfoImpl(ClassLoader classLoader, URL persistenceUnitRootUrl) {
        this.setClassLoader(classLoader);
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = new TransformClassLoader(classLoader);
    }

    public ClassLoader getNewTempClassLoader() {
        return new ChildFirstClassLoader(this.classLoader);
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public void addMappingFileNames(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public void addJarFileUrls(URL jarFileUrl) {
        this.jarFileUrls.add(jarFileUrl);
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void addManagedClassNames(String managedClassName) {
        this.managedClassNames.add(managedClassName);
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addProperties(String key, String value) {
        this.properties.put(key, value);
    }

    public List<ClassTransformer> getTransformers() {
        return this.transformers;
    }

    public void addTransformer(ClassTransformer transformer) {
        this.transformers.add(transformer);
        this.classLoader.addTransformer(transformer);
    }

    public TransformClassLoader getTransformClassLoader() {
        return this.classLoader;
    }
}

