/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.util.ResourceLoader;

public abstract class Encoding
implements COSObjectable {
    protected Map codeToName = new HashMap();
    protected Map nameToCode = new HashMap();
    private static final Map NAME_TO_CHARACTER;
    private static final Map CHARACTER_TO_NAME;
    static /* synthetic */ Class class$org$apache$pdfbox$encoding$Encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadGlyphList(String location) {
        BufferedReader glyphStream = null;
        try {
            InputStream resource = ResourceLoader.loadResource(location);
            glyphStream = new BufferedReader(new InputStreamReader(resource));
            String line = null;
            while ((line = glyphStream.readLine()) != null) {
                int semicolonIndex;
                if ((line = line.trim()).startsWith("#") || (semicolonIndex = line.indexOf(59)) < 0) continue;
                try {
                    String characterName = line.substring(0, semicolonIndex);
                    String unicodeValue = line.substring(semicolonIndex + 1, line.length());
                    StringTokenizer tokenizer = new StringTokenizer(unicodeValue, " ", false);
                    String value = "";
                    while (tokenizer.hasMoreTokens()) {
                        int characterCode = Integer.parseInt(tokenizer.nextToken(), 16);
                        value = value + (char)characterCode;
                    }
                    NAME_TO_CHARACTER.put(COSName.getPDFName(characterName), value);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (glyphStream != null) {
                try {
                    glyphStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void addCharacterEncoding(int code, COSName name) {
        Integer intCode = new Integer(code);
        this.codeToName.put(intCode, name);
        this.nameToCode.put(name, intCode);
    }

    public int getCode(COSName name) throws IOException {
        Integer code = (Integer)this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name.getName() + "'");
        }
        return code;
    }

    public COSName getName(int code) throws IOException {
        COSName name = (COSName)this.codeToName.get(new Integer(code));
        if (name == null) {
            name = COSName.getPDFName("space");
        }
        return name;
    }

    public COSName getNameFromCharacter(char c) throws IOException {
        COSName name = (COSName)CHARACTER_TO_NAME.get("" + c);
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String character = Encoding.getCharacter(this.getName(code));
        return character;
    }

    public static String getCharacter(COSName name) {
        String character;
        COSName baseName = name;
        String nameStr = baseName.getName();
        if (nameStr.indexOf(46) > 0) {
            nameStr = nameStr.substring(0, nameStr.indexOf(46));
            baseName = COSName.getPDFName(nameStr);
        }
        if ((character = (String)NAME_TO_CHARACTER.get(baseName)) == null) {
            if (nameStr.startsWith("uni")) {
                StringBuffer uniStr = new StringBuffer();
                int chPos = 3;
                while (chPos + 4 <= nameStr.length()) {
                    try {
                        int characterCode = Integer.parseInt(nameStr.substring(chPos, chPos + 4), 16);
                        if (characterCode > 55295 && characterCode < 57344) {
                            Logger.getLogger((class$org$apache$pdfbox$encoding$Encoding == null ? Encoding.class$("org.apache.pdfbox.encoding.Encoding") : class$org$apache$pdfbox$encoding$Encoding).getName()).log(Level.WARNING, "Unicode character name with not allowed code area: " + nameStr);
                        } else {
                            uniStr.append((char)characterCode);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Logger.getLogger((class$org$apache$pdfbox$encoding$Encoding == null ? Encoding.class$("org.apache.pdfbox.encoding.Encoding") : class$org$apache$pdfbox$encoding$Encoding).getName()).log(Level.WARNING, "Not a number in Unicode character name: " + nameStr);
                    }
                    chPos += 4;
                }
                character = uniStr.toString();
            } else {
                character = nameStr;
            }
        }
        return character;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ COSBase getCOSObject();

    static {
        File external;
        NAME_TO_CHARACTER = new HashMap();
        CHARACTER_TO_NAME = new HashMap();
        Encoding.loadGlyphList("Resources/glyphlist.txt");
        String location = System.getProperty("glyphlist_ext");
        if (location != null && (external = new File(location)).exists()) {
            Encoding.loadGlyphList(location);
        }
        NAME_TO_CHARACTER.put(COSName.getPDFName(".notdef"), "");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fi"), "fi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fl"), "fl");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ffi"), "ffi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ff"), "ff");
        NAME_TO_CHARACTER.put(COSName.getPDFName("pi"), "pi");
        Iterator keys = NAME_TO_CHARACTER.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = NAME_TO_CHARACTER.get(key);
            CHARACTER_TO_NAME.put(value, key);
        }
    }
}

