/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.MacRomanEncoding;
import org.apache.pdfbox.encoding.PdfDocEncoding;
import org.apache.pdfbox.encoding.StandardEncoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;

public class EncodingManager {
    private static final Map ENCODINGS = new HashMap();

    public Encoding getStandardEncoding() {
        return (Encoding)ENCODINGS.get(COSName.STANDARD_ENCODING);
    }

    public Encoding getEncoding(COSName name) throws IOException {
        Encoding encoding = (Encoding)ENCODINGS.get(name);
        if (encoding == null) {
            throw new IOException("Unknown encoding for '" + name.getName() + "'");
        }
        return encoding;
    }

    static {
        ENCODINGS.put(COSName.MAC_ROMAN_ENCODING, new MacRomanEncoding());
        ENCODINGS.put(COSName.PDF_DOC_ENCODING, new PdfDocEncoding());
        ENCODINGS.put(COSName.STANDARD_ENCODING, new StandardEncoding());
        ENCODINGS.put(COSName.WIN_ANSI_ENCODING, new WinAnsiEncoding());
    }
}

